/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePluginData {
    private String projectName;
    private String basePackage;
    private List<String> pluginDependencies;
    private Map<String, String> packageClassNames;
    private CreateRunnableData runnableData;

    public CreatePluginData(String projectName) {
        this.projectName = projectName;
        this.basePackage = String.valueOf(projectName) + ".files";
    }

    public CreatePluginData(String projectName, String basePackage) {
        this.projectName = projectName;
        this.basePackage = basePackage;
    }

    public void setRunnableData(CreateRunnableData runnableData) {
        this.runnableData = runnableData;
        this.computeMetamodelDependencies();
    }

    private void computeMetamodelDependencies() {
        this.pluginDependencies = new ArrayList<String>();
        this.packageClassNames = new HashMap<String, String>();
        for (String metamodelName : this.runnableData.getAllMetamodelsNames()) {
            EPackage regValue = EPackage.Registry.INSTANCE.getEPackage(this.runnableData.getMetamodelLocations().get(metamodelName));
            if (regValue == null) continue;
            this.computeMetamodelDependencies(metamodelName, regValue);
        }
    }

    private void computeMetamodelDependencies(String metamodelName, EPackage metamodel) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        if (extensionPoint != null && extensionPoint.getExtensions().length > 0) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] members = extension.getConfigurationElements();
                int j = 0;
                while (j < members.length) {
                    IConfigurationElement member = members[j];
                    String mURI = member.getAttribute("uri");
                    if (mURI != null && mURI.equals(metamodel.getNsURI())) {
                        if (!this.pluginDependencies.contains(member.getNamespaceIdentifier())) {
                            this.pluginDependencies.add(member.getNamespaceIdentifier());
                        }
                        this.packageClassNames.put(metamodelName, member.getAttribute("class"));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public CreateRunnableData getRunnableData() {
        return this.runnableData;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Object getBasePackage() {
        return this.basePackage;
    }

    public List<String> getPluginDependencies() {
        return this.pluginDependencies;
    }

    public Map<String, String> getPackageClassNames() {
        return this.packageClassNames;
    }
}

