/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class AtlCompletionProposal
implements ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposal {
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private int fCursorPosition;
    private String fDisplayString;
    private Image fImage;
    private int fRelevance;
    private StyleRange fRememberedStyleRange;
    private int fReplacementLength;
    private int fReplacementOffset;
    private String fReplacementString;
    protected ITextViewer fTextViewer;
    protected boolean fToggleEating;
    private char[] fTriggerCharacters;

    private static Color getBackgroundColor(StyledText text) {
        IPreferenceStore preference = AtlUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"Atl.CodeAssist.ReplacementBackground");
        AtlTextTools textTools = AtlUIPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static Color getForegroundColor(StyledText text) {
        IPreferenceStore preference = AtlUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"Atl.CodeAssistReplacementForeground");
        AtlTextTools textTools = AtlUIPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static boolean insertCompletion() {
        return true;
    }

    public AtlCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, null);
    }

    public AtlCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, ITextViewer viewer) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fRelevance = relevance;
        this.fTextViewer = viewer;
        this.fCursorPosition = replacementString.length();
        this.fContextInformation = null;
        this.fContextInformationPosition = -1;
        this.fTriggerCharacters = null;
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            IPreferenceStore preferenceStore;
            int index;
            String string;
            boolean isSmartTrigger;
            int delta = offset - (this.fReplacementOffset + this.fReplacementLength);
            if (delta > 0) {
                this.fReplacementLength += delta;
            }
            boolean bl = isSmartTrigger = trigger == ';' && AtlUIPlugin.getDefault().getPreferenceStore().getBoolean("Atl.Typing.SmarttSemicolon") || trigger == '{' && AtlUIPlugin.getDefault().getPreferenceStore().getBoolean("Atl.Typing.SmarttOpeningBrace");
            if (isSmartTrigger || trigger == '\u0000') {
                string = this.fReplacementString;
            } else {
                StringBuffer buffer = new StringBuffer(this.fReplacementString);
                if (this.fCursorPosition > 0 && this.fCursorPosition <= buffer.length() && buffer.charAt(this.fCursorPosition - 1) != trigger) {
                    buffer.insert(this.fCursorPosition, trigger);
                    ++this.fCursorPosition;
                }
                string = buffer.toString();
            }
            int referenceOffset = this.fReplacementOffset + this.fReplacementLength;
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(document, referenceOffset);
            this.replace(document, this.fReplacementOffset, this.fReplacementLength, string);
            referenceOffset = referenceTracker.postReplace(document);
            this.fReplacementOffset = referenceOffset - (string == null ? 0 : string.length());
            if (isSmartTrigger) {
                DocumentCommand cmd = new DocumentCommand(){};
                cmd.offset = referenceOffset;
                cmd.length = 0;
                cmd.text = Character.toString(trigger);
                cmd.doit = true;
                cmd.shiftsCaret = true;
                cmd.caretOffset = this.fReplacementOffset + this.fCursorPosition;
                this.replace(document, cmd.offset, cmd.length, cmd.text);
                this.setCursorPosition(cmd.caretOffset - this.fReplacementOffset + cmd.text.length());
            }
            if (this.fTextViewer != null && string != null && (index = string.indexOf("()")) != -1 && index + 1 == this.fCursorPosition && (preferenceStore = AtlUIPlugin.getDefault().getPreferenceStore()).getBoolean("Atl.Typing.ClolseBrackets")) {
                int newOffset = this.fReplacementOffset + this.fCursorPosition;
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, newOffset, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.fTextViewer);
                ui.setSimpleMode(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')'));
                ui.setExitPosition(this.fTextViewer, newOffset + 1, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        boolean bl = this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        if (AtlCompletionProposal.insertCompletion() ^ this.fToggleEating) {
            this.fReplacementLength = selection.x + selection.y - this.fReplacementOffset;
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        return string;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (widgetRange != null) {
                        viewer2.invalidateTextPresentation(widgetRange.getOffset(), widgetRange.getLength());
                    }
                } else {
                    viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start + viewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (!AtlCompletionProposal.insertCompletion() ^ smartToggle) {
            this.updateStyle(viewer);
        } else {
            this.repairPresentation(viewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return word.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    public void updateReplacementLength(int length) {
        this.setReplacementLength(length);
    }

    public void updateReplacementOffset(int newOffset) {
        this.setReplacementOffset(newOffset);
    }

    private void updateStyle(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= this.fReplacementOffset + this.fReplacementLength) {
            this.repairPresentation(viewer);
            return;
        }
        int offset = widgetCaret;
        int length = this.fReplacementOffset + this.fReplacementLength - modelCaret;
        Color foreground = AtlCompletionProposal.getForegroundColor(text);
        Color background = AtlCompletionProposal.getBackgroundColor(text);
        StyleRange range = text.getStyleRangeAtOffset(offset);
        int fontStyle = range != null ? range.fontStyle : 0;
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = new StyleRange(offset, length, foreground, background, fontStyle);
        try {
            text.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fDisplayString);
        if (validated && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            this.fReplacementLength += delta;
        }
        return validated;
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;

        public ExitPolicy(char exitCharacter) {
            this.fExitCharacter = exitCharacter;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
            }
            return null;
        }
    }

    private static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final Position fPosition = new Position(0);
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");

        private ReferenceTracker() {
        }

        public int postReplace(IDocument document) {
            try {
                document.removePosition(CATEGORY, this.fPosition);
                document.removePositionUpdater(this.fPositionUpdater);
                document.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                AtlUIPlugin.log(e);
            }
            return this.fPosition.getOffset();
        }

        public void preReplace(IDocument document, int offset) throws BadLocationException {
            this.fPosition.setOffset(offset);
            try {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(this.fPositionUpdater);
                document.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException e) {
                AtlUIPlugin.log(e);
            }
        }
    }
}

