/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class EditUIUtil {
    public static boolean openEditor(EObject eObject) throws PartInitException {
        URI uri;
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null && (uri = resource.getURI()) != null) {
            URIEditorInput editorInput = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    editorInput = EclipseUtil.createFileEditorInput((IFile)workspaceResource);
                }
            } else {
                editorInput = new URIEditorInput(uri);
            }
            if (editorInput != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.openEditor((IEditorInput)editorInput, workbench.getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
                return editorPart != null;
            }
        }
        return false;
    }

    public static URI getURI(IEditorInput editorInput) {
        URI result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseUtil.getURI(editorInput);
        }
        if (result == null) {
            result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        }
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(String fileName) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName)) : null;
    }

    public static IEditorDescriptor getDefaultEditor(InputStream contents, String fileName) {
        if (contents != null) {
            try {
                return EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName));
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getDefaultEditor(fileName);
    }

    private static IEditorDescriptor getDefaultEditor(String fileName, IContentType[] contentTypes) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getDefaultEditor(fileName, null);
        }
        IEditorDescriptor result = null;
        int i = 0;
        while (result == null && i < contentTypes.length) {
            result = editorRegistry.getDefaultEditor(fileName, contentTypes[i]);
            ++i;
        }
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(URI uri, URIConverter uriConverter) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(stream, fileName);
            return iEditorDescriptor;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(fileName);
            return iEditorDescriptor;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
    }

    public static IEditorDescriptor[] getEditors(String fileName, boolean defaultsOnly) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName), defaultsOnly) : new IEditorDescriptor[]{};
    }

    public static IEditorDescriptor[] getEditors(InputStream contents, String fileName, boolean defaultsOnly) {
        if (contents != null) {
            try {
                return EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName), defaultsOnly);
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getEditors(fileName, defaultsOnly);
    }

    private static IEditorDescriptor[] getEditors(String fileName, IContentType[] contentTypes, boolean defaultsOnly) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getEditors(fileName, null);
        }
        UniqueEList result = new UniqueEList();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (defaultsOnly) {
                IEditorDescriptor editor = editorRegistry.getDefaultEditor(fileName, contentType);
                if (editor != null) {
                    result.add(editor);
                }
            } else {
                result.addAll(Arrays.asList(editorRegistry.getEditors(fileName, contentType)));
            }
            ++n2;
        }
        return result.toArray(new IEditorDescriptor[result.size()]);
    }

    public static IEditorDescriptor[] getEditors(URI uri, URIConverter uriConverter, boolean defaultsOnly) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(stream, fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }

    private static class EclipseUtil {
        static final Class<?> FILE_CLASS;
        static final Class<?> FILE_REVISION_CLASS;
        static final Method FILE_REVISION_GET_URI_METHOD;
        static final Class<?> URI_EDITOR_INPUT_CLASS;

        static {
            Class<IFile> fileClass = null;
            try {
                fileClass = IFile.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FILE_CLASS = fileClass;
            Class fileRevisionClass = null;
            Method fileRevisionGetURIMethod = null;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.team.core");
            if (bundle != null && (bundle.getState() & 0x2C) != 0) {
                try {
                    fileRevisionClass = bundle.loadClass("org.eclipse.team.core.history.IFileRevision");
                    fileRevisionGetURIMethod = fileRevisionClass.getMethod("getURI", new Class[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            FILE_REVISION_CLASS = fileRevisionClass;
            FILE_REVISION_GET_URI_METHOD = fileRevisionGetURIMethod;
            Class<IURIEditorInput> uriEditorInputClass = null;
            try {
                uriEditorInputClass = IURIEditorInput.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
        }

        private EclipseUtil() {
        }

        public static URI getURI(IEditorInput editorInput) {
            java.net.URI javaNetURI;
            Object fileRevision;
            IFile file;
            if (FILE_CLASS != null && (file = (IFile)editorInput.getAdapter(FILE_CLASS)) != null) {
                return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            }
            if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
                try {
                    return URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
                }
                catch (Throwable exception) {
                    EMFEditUIPlugin.INSTANCE.log(exception);
                }
            }
            if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
                return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
            }
            URI uri = (URI)editorInput.getAdapter(URI.class);
            if (uri == null && (javaNetURI = (java.net.URI)editorInput.getAdapter(java.net.URI.class)) != null) {
                uri = URI.createURI((String)javaNetURI.toString());
            }
            return uri;
        }

        public static IEditorInput createFileEditorInput(IFile file) {
            return new FileEditorInput(file);
        }
    }
}

