/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.menuContributor;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.navigation.menu.button.NavigationSubMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuButton;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenuContributor;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.uml.navigation.Activator;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;

public class TargetsButton
implements NavigationMenuContributor {
    public List<NavigationMenuButton> getButtons(Object fromElement) {
        LinkedList<NavigationMenuButton> buttons = new LinkedList<NavigationMenuButton>();
        if (fromElement instanceof Element) {
            try {
                NavigationService navigationService = (NavigationService)ServiceUtilsForEObject.getInstance().getService(NavigationService.class, (Object)((Element)fromElement));
                EList relationships = ((Element)fromElement).getSourceDirectedRelationships();
                if (!relationships.isEmpty()) {
                    LinkedList navigableElements = new LinkedList();
                    for (DirectedRelationship relationship : relationships) {
                        for (Element target : relationship.getTargets()) {
                            navigableElements.addAll(navigationService.getNavigableElements((Object)target));
                        }
                    }
                    if (!navigableElements.isEmpty()) {
                        buttons.add((NavigationMenuButton)new NavigationSubMenuButton("Targets...", null, "Show targets", navigableElements));
                    }
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return buttons;
    }
}

