/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Profile;

public class UMLDiagramContentInitializer {
    private Map myDomain2NotationMap = new HashMap();
    private Collection myLinkDescriptors = new LinkedList();

    public void initDiagramContent(Diagram diagram) {
        if (!"PapyrusUMLProfileDiagram".equals(diagram.getType())) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram passed as a parameter: " + diagram.getType());
            return;
        }
        if (!(diagram.getElement() instanceof Profile)) {
            UMLDiagramEditorPlugin.getInstance().logError("Incorrect diagram element specified: " + String.valueOf(diagram.getElement()) + " instead of Profile");
            return;
        }
        this.createProfile_ProfileDiagram_Children((View)diagram);
        this.createLinks(diagram);
    }

    private void createProfile_ProfileDiagram_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getProfile_ProfileDiagram_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDependency_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDependency_Shape_OutgoingLinks(view));
    }

    private void createAssociation_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getAssociation_Shape_OutgoingLinks(view));
    }

    private void createStereotype_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getStereotype_Shape_OutgoingLinks(view));
        this.createStereotype_AttributeCompartment_Children((View)this.getCompartment(view, "Stereotype_AttributeCompartment"));
        this.createStereotype_OperationCompartment_Children((View)this.getCompartment(view, "Stereotype_OperationCompartment"));
    }

    private void createClass_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getClass_Shape_OutgoingLinks(view));
        this.createClass_OperationCompartment_Children((View)this.getCompartment(view, "Class_OperationCompartment"));
        this.createClass_AttributeCompartment_Children((View)this.getCompartment(view, "Class_AttributeCompartment"));
    }

    private void createClass_MetaclassShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getClass_MetaclassShape_OutgoingLinks(view));
    }

    private void createComment_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getComment_Shape_OutgoingLinks(view));
    }

    private void createConstraint_PackagedElementShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getConstraint_PackagedElementShape_OutgoingLinks(view));
    }

    private void createModel_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getModel_Shape_OutgoingLinks(view));
        this.createModel_PackagedElementCompartment_Children((View)this.getCompartment(view, "Model_PackagedElementCompartment"));
    }

    private void createProfile_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getProfile_Shape_OutgoingLinks(view));
        this.createProfile_PackagedElementCompartment_Children((View)this.getCompartment(view, "Profile_PackagedElementCompartment"));
    }

    private void createPackage_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getPackage_Shape_OutgoingLinks(view));
        this.createPackage_PackagedElementCompartment_Children((View)this.getCompartment(view, "Package_PackagedElementCompartment"));
    }

    private void createEnumeration_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getEnumeration_Shape_OutgoingLinks(view));
        this.createEnumeration_LiteralCompartment_Children((View)this.getCompartment(view, "Enumeration_LiteralCompartment"));
    }

    private void createPrimitiveType_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getPrimitiveType_Shape_OutgoingLinks(view));
    }

    private void createDataType_Shape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDataType_Shape_OutgoingLinks(view));
        this.createDataType_AttributeCompartment_Children((View)this.getCompartment(view, "DataType_AttributeCompartment"));
        this.createDataType_OperationCompartment_Children((View)this.getCompartment(view, "DataType_OperationCompartment"));
    }

    private void createDiagram_ShortcutShape_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDiagram_ShortcutShape_OutgoingLinks(view));
    }

    private void createPrimitiveType_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getPrimitiveType_Shape_CN_OutgoingLinks(view));
    }

    private void createOperation_DataTypeOperationLabel_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getOperation_DataTypeOperationLabel_OutgoingLinks(view));
    }

    private void createEnumerationLiteral_LiteralLabel_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getEnumerationLiteral_LiteralLabel_OutgoingLinks(view));
    }

    private void createProperty_DataTypeAttributeLabel_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getProperty_DataTypeAttributeLabel_OutgoingLinks(view));
    }

    private void createProperty_ClassAttributeLabel_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getProperty_ClassAttributeLabel_OutgoingLinks(view));
    }

    private void createOperation_ClassOperationLabel_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getOperation_ClassOperationLabel_OutgoingLinks(view));
    }

    private void createStereotype_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getStereotype_Shape_CN_OutgoingLinks(view));
        this.createStereotype_AttributeCompartment_CN_Children((View)this.getCompartment(view, "Stereotype_AttributeCompartment_CN"));
        this.createStereotype_OperationCompartment_CN_Children((View)this.getCompartment(view, "Stereotype_OperationCompartment_CN"));
    }

    private void createClass_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getClass_Shape_CN_OutgoingLinks(view));
        this.createClass_AttributeCompartment_CN_Children((View)this.getCompartment(view, "Class_AttributeCompartment_CN"));
        this.createClass_OperationCompartment_CN_Children((View)this.getCompartment(view, "Class_OperationCompartment_CN"));
    }

    private void createClass_MetaclassShape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getClass_MetaclassShape_CN_OutgoingLinks(view));
    }

    private void createComment_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getComment_Shape_CN_OutgoingLinks(view));
    }

    private void createModel_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getModel_Shape_CN_OutgoingLinks(view));
        this.createModel_PackagedElementCompartment_CN_Children((View)this.getCompartment(view, "Model_PackagedElementCompartment_CN"));
    }

    private void createProfile_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getProfile_Shape_CN_OutgoingLinks(view));
        this.createProfile_PackagedElementCompartment_CN_Children((View)this.getCompartment(view, "Profile_PackagedElementCompartment_CN"));
    }

    private void createPackage_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getPackage_Shape_CN_OutgoingLinks(view));
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getPackage_Shape_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
        this.createPackage_PackagedElementCompartment_CN_Children((View)this.getCompartment(view, "Package_PackagedElementCompartment_CN"));
    }

    private void createConstraint_PackagedElementShape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getConstraint_PackagedElementShape_CN_OutgoingLinks(view));
    }

    private void createEnumeration_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getEnumeration_Shape_CN_OutgoingLinks(view));
        this.createEnumeration_LiteralCompartment_CN_Children((View)this.getCompartment(view, "Enumeration_LiteralCompartment_CN"));
    }

    private void createDataType_Shape_CN_Children(View view) {
        this.myDomain2NotationMap.put(view.getElement(), view);
        this.myLinkDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDataType_Shape_CN_OutgoingLinks(view));
        this.createDataType_AttributeCompartment_CN_Children((View)this.getCompartment(view, "DataType_AttributeCompartment_CN"));
        this.createDataType_OperationCompartment_CN_Children((View)this.getCompartment(view, "DataType_OperationCompartment_CN"));
    }

    private void createPackage_PackagedElementCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getPackage_PackagedElementCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createPackage_PackagedElementCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getPackage_PackagedElementCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createProfile_PackagedElementCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getProfile_PackagedElementCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createProfile_PackagedElementCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getProfile_PackagedElementCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotype_AttributeCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getStereotype_AttributeCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotype_AttributeCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getStereotype_AttributeCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotype_OperationCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getStereotype_OperationCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createStereotype_OperationCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getStereotype_OperationCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createModel_PackagedElementCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getModel_PackagedElementCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createModel_PackagedElementCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getModel_PackagedElementCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createEnumeration_LiteralCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getEnumeration_LiteralCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createEnumeration_LiteralCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getEnumeration_LiteralCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataType_AttributeCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getDataType_AttributeCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataType_AttributeCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getDataType_AttributeCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataType_OperationCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getDataType_OperationCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createDataType_OperationCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getDataType_OperationCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createClass_AttributeCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getClass_AttributeCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createClass_AttributeCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getClass_AttributeCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createClass_OperationCompartment_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getClass_OperationCompartment_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createClass_OperationCompartment_CN_Children(View view) {
        List<UMLNodeDescriptor> childNodeDescriptors = UMLDiagramUpdater.INSTANCE.getClass_OperationCompartment_CN_SemanticChildren(view);
        Iterator it = childNodeDescriptors.iterator();
        while (it.hasNext()) {
            this.createNode(view, (UMLNodeDescriptor)((Object)it.next()));
        }
    }

    private void createNode(View parentView, UMLNodeDescriptor nodeDescriptor) {
        String nodeType = UMLVisualIDRegistry.getType(nodeDescriptor.getVisualID());
        Node node = ViewService.createNode((View)parentView, (EObject)nodeDescriptor.getModelElement(), (String)nodeType, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        switch (nodeDescriptor.getVisualID()) {
            case "Dependency_Shape": {
                this.createDependency_Shape_Children((View)node);
                return;
            }
            case "Association_Shape": {
                this.createAssociation_Shape_Children((View)node);
                return;
            }
            case "Stereotype_Shape": {
                this.createStereotype_Shape_Children((View)node);
                return;
            }
            case "Class_Shape": {
                this.createClass_Shape_Children((View)node);
                return;
            }
            case "Class_MetaclassShape": {
                this.createClass_MetaclassShape_Children((View)node);
                return;
            }
            case "Comment_Shape": {
                this.createComment_Shape_Children((View)node);
                return;
            }
            case "Constraint_PackagedElementShape": {
                this.createConstraint_PackagedElementShape_Children((View)node);
                return;
            }
            case "Model_Shape": {
                this.createModel_Shape_Children((View)node);
                return;
            }
            case "Profile_Shape": {
                this.createProfile_Shape_Children((View)node);
                return;
            }
            case "Package_Shape": {
                this.createPackage_Shape_Children((View)node);
                return;
            }
            case "Enumeration_Shape": {
                this.createEnumeration_Shape_Children((View)node);
                return;
            }
            case "PrimitiveType_Shape": {
                this.createPrimitiveType_Shape_Children((View)node);
                return;
            }
            case "DataType_Shape": {
                this.createDataType_Shape_Children((View)node);
                return;
            }
            case "Diagram_ShortcutShape": {
                this.createDiagram_ShortcutShape_Children((View)node);
                return;
            }
            case "PrimitiveType_Shape_CN": {
                this.createPrimitiveType_Shape_CN_Children((View)node);
                return;
            }
            case "Operation_DataTypeOperationLabel": {
                this.createOperation_DataTypeOperationLabel_Children((View)node);
                return;
            }
            case "EnumerationLiteral_LiteralLabel": {
                this.createEnumerationLiteral_LiteralLabel_Children((View)node);
                return;
            }
            case "Property_DataTypeAttributeLabel": {
                this.createProperty_DataTypeAttributeLabel_Children((View)node);
                return;
            }
            case "Property_ClassAttributeLabel": {
                this.createProperty_ClassAttributeLabel_Children((View)node);
                return;
            }
            case "Operation_ClassOperationLabel": {
                this.createOperation_ClassOperationLabel_Children((View)node);
                return;
            }
            case "Stereotype_Shape_CN": {
                this.createStereotype_Shape_CN_Children((View)node);
                return;
            }
            case "Class_Shape_CN": {
                this.createClass_Shape_CN_Children((View)node);
                return;
            }
            case "Class_MetaclassShape_CN": {
                this.createClass_MetaclassShape_CN_Children((View)node);
                return;
            }
            case "Comment_Shape_CN": {
                this.createComment_Shape_CN_Children((View)node);
                return;
            }
            case "Model_Shape_CN": {
                this.createModel_Shape_CN_Children((View)node);
                return;
            }
            case "Profile_Shape_CN": {
                this.createProfile_Shape_CN_Children((View)node);
                return;
            }
            case "Package_Shape_CN": {
                this.createPackage_Shape_CN_Children((View)node);
                return;
            }
            case "Constraint_PackagedElementShape_CN": {
                this.createConstraint_PackagedElementShape_CN_Children((View)node);
                return;
            }
            case "Enumeration_Shape_CN": {
                this.createEnumeration_Shape_CN_Children((View)node);
                return;
            }
            case "DataType_Shape_CN": {
                this.createDataType_Shape_CN_Children((View)node);
                return;
            }
        }
    }

    private void createLinks(Diagram diagram) {
        boolean continueLinkCreation = true;
        while (continueLinkCreation) {
            continueLinkCreation = false;
            LinkedList<UMLLinkDescriptor> additionalDescriptors = new LinkedList<UMLLinkDescriptor>();
            Iterator it = this.myLinkDescriptors.iterator();
            while (it.hasNext()) {
                UMLLinkDescriptor nextLinkDescriptor = (UMLLinkDescriptor)((Object)it.next());
                if (!this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getSource()) || !this.myDomain2NotationMap.containsKey(nextLinkDescriptor.getDestination())) continue;
                String linkType = UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID());
                Edge edge = ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)diagram, linkType, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (edge == null) continue;
                edge.setSource((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getSource()));
                edge.setTarget((View)this.myDomain2NotationMap.get(nextLinkDescriptor.getDestination()));
                it.remove();
                if (nextLinkDescriptor.getModelElement() != null) {
                    this.myDomain2NotationMap.put(nextLinkDescriptor.getModelElement(), edge);
                }
                continueLinkCreation = true;
                switch (nextLinkDescriptor.getVisualID()) {
                    case "Extension_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getExtension_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Association_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getAssociation_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "ProfileApplication_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getProfileApplication_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Association_BranchEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getAssociation_BranchEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Generalization_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getGeneralization_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Dependency_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDependency_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "Dependency_BranchEdge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getDependency_BranchEdge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "ElementImport_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getElementImport_Edge_OutgoingLinks((View)edge));
                        break;
                    }
                    case "PackageImport_Edge": {
                        additionalDescriptors.addAll(UMLDiagramUpdater.INSTANCE.getPackageImport_Edge_OutgoingLinks((View)edge));
                    }
                }
            }
            this.myLinkDescriptors.addAll(additionalDescriptors);
        }
    }

    private Node getCompartment(View node, String visualID) {
        String type = UMLVisualIDRegistry.getType(visualID);
        for (View nextView : node.getChildren()) {
            if (!(nextView instanceof Node) || !type.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }
}

