/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.profile.StereotypeUtil;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesStereotypeApplicationServices {
    private static final String BOOLEAN_OBJECT_UNSET_LITERAL = "null";
    private static final String BOOLEAN_OBJECT_TRUE_LITERAL = "true";
    private static final String BOOLEAN_OBJECT_FALSE_LITERAL = "false";
    private ILogger logger;

    public PropertiesStereotypeApplicationServices(ILogger logger) {
        this.logger = logger;
    }

    public List<EStructuralFeature> getAllFeatures(EObject target) {
        return target.eClass().getEAllStructuralFeatures().stream().filter(this::isValidFeature).toList();
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return !feature.getName().startsWith("base_") && !feature.isTransient() && !feature.isDerived() && !this.isContainmentReference(feature);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isContainmentReference(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EReference) {
            void reference;
            EReference eReference = (EReference)eStructuralFeature;
            EReference cfr_ignored_0 = (EReference)eStructuralFeature;
            return reference.isContainment();
        }
        return false;
    }

    public boolean isEditable(EStructuralFeature feature) {
        return feature.isChangeable() && !feature.isTransient();
    }

    public Object getStereotypeFeatureValue(EObject stereotypeApplication, EStructuralFeature feature) {
        return stereotypeApplication.eGet(feature);
    }

    /*
     * WARNING - void declaration
     */
    public Object getStereotypeFeatureBaseElementValue(EObject stereotypeApplication, EReference reference) {
        Object result;
        Object value = stereotypeApplication.eGet((EStructuralFeature)reference);
        Object object = value;
        if (object instanceof EObject) {
            void eObject;
            EObject eObject2 = (EObject)object;
            EObject cfr_ignored_0 = (EObject)object;
            result = StereotypeUtil.getBaseElement((EObject)eObject);
        } else {
            result = value instanceof List ? ((List)value).stream().filter(e -> e instanceof EObject).map(e -> (EObject)e).map(StereotypeUtil::getBaseElement).toList() : null;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Object getStereotypeEnumerationValue(EObject stereotypeApplication, EStructuralFeature feature) {
        Object value = stereotypeApplication.eGet(feature);
        Object object = value;
        if (object instanceof EEnumLiteral) {
            void literal;
            EEnumLiteral eEnumLiteral = (EEnumLiteral)object;
            EEnumLiteral cfr_ignored_0 = (EEnumLiteral)object;
            return literal.getLiteral();
        }
        return null;
    }

    public Object getStereotypeBooleanObjectValue(EObject stereotypeApplication, EStructuralFeature feature) {
        Object value;
        if (this.isMonoBooleanObjectAttribute(feature) && (value = stereotypeApplication.eGet(feature)) != null) {
            return value.toString();
        }
        return BOOLEAN_OBJECT_UNSET_LITERAL;
    }

    private void setIntegerValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Integer number = Integer.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting an integer number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    private void setDoubleValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Double number = Double.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting a double number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    private void setFloatValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Float number = Float.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting a float number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    public Object setStereotypeFeatureValue(EObject stereotypeApplication, EStructuralFeature feature, Object value) {
        if (this.isMonoIntegerAttribute(feature)) {
            this.setIntegerValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoDoubleAttribute(feature)) {
            this.setDoubleValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoFloatAttribute(feature)) {
            this.setFloatValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoBooleanAttribute(feature)) {
            stereotypeApplication.eSet(feature, value);
        } else if (this.isMonoBooleanObjectAttribute(feature)) {
            stereotypeApplication.eSet(feature, (Object)this.getBooleanObjectLiteral((String)value));
        } else if (this.isMonoStringAttribute(feature)) {
            stereotypeApplication.eSet(feature, value);
        } else if (this.isMonoEnumeration(feature)) {
            stereotypeApplication.eSet(feature, (Object)this.getEnumLiteral(feature, (String)value));
        }
        return stereotypeApplication;
    }

    /*
     * WARNING - void declaration
     */
    private EEnumLiteral getEnumLiteral(EStructuralFeature feature, String value) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            EDataType type;
            EDataType eDataType;
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany() && (eDataType = (type = attr.getEAttributeType())) instanceof EEnum) {
                void enumeration;
                EEnum eEnum = (EEnum)eDataType;
                EEnum cfr_ignored_1 = (EEnum)eDataType;
                return enumeration.getEEnumLiteral(value);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoStringAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, String.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiStringAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, String.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoBooleanAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Boolean.TYPE);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiBooleanAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Boolean.TYPE) || this.isAttributeOfType((EAttribute)attr, Boolean.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoBooleanObjectAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Boolean.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoIntegerAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Integer.TYPE) || this.isAttributeOfType((EAttribute)attr, Integer.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiIntegerAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Integer.TYPE) || this.isAttributeOfType((EAttribute)attr, Integer.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoDoubleAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Double.TYPE) || this.isAttributeOfType((EAttribute)attr, Double.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiDoubleAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Double.TYPE) || this.isAttributeOfType((EAttribute)attr, Double.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoFloatAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Float.TYPE) || this.isAttributeOfType((EAttribute)attr, Float.class);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiFloatAttribute(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany()) {
                return this.isAttributeOfType((EAttribute)attr, Float.TYPE) || this.isAttributeOfType((EAttribute)attr, Float.class);
            }
        }
        return false;
    }

    private boolean isAttributeOfType(EAttribute attr, Class<?> expectedType) {
        Class instanceClass;
        EDataType type = attr.getEAttributeType();
        if (type != null && (instanceClass = type.getInstanceClass()) != null) {
            return instanceClass.isAssignableFrom(expectedType);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoEnumeration(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            EDataType type;
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (!attr.isMany() && (type = attr.getEAttributeType()) instanceof EEnum) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiEnumeration(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            EDataType type;
            void attr;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            if (attr.isMany() && (type = attr.getEAttributeType()) instanceof EEnum) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getStereotypeEnumerationLiterals(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EAttribute) {
            void attr;
            EDataType type;
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EAttribute cfr_ignored_0 = (EAttribute)eStructuralFeature;
            EDataType eDataType = type = attr.getEAttributeType();
            if (eDataType instanceof EEnum) {
                void enumeration;
                EEnum eEnum = (EEnum)eDataType;
                EEnum cfr_ignored_1 = (EEnum)eDataType;
                return enumeration.getELiterals().stream().map(EEnumLiteral::getLiteral).toList();
            }
        }
        return List.of();
    }

    public List<String> getStereotypeBooleanObjectLiterals(EStructuralFeature feature) {
        return List.of(BOOLEAN_OBJECT_TRUE_LITERAL, BOOLEAN_OBJECT_FALSE_LITERAL, BOOLEAN_OBJECT_UNSET_LITERAL);
    }

    private Boolean getBooleanObjectLiteral(String value) {
        if (BOOLEAN_OBJECT_UNSET_LITERAL.equals(value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMonoReference(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EReference) {
            void ref;
            EReference eReference = (EReference)eStructuralFeature;
            EReference cfr_ignored_0 = (EReference)eStructuralFeature;
            if (!ref.isMany()) {
                return true;
            }
        }
        return false;
    }

    public boolean isUMLDataType(EClassifier classifier) {
        return classifier.getEPackage() == UMLPackage.eINSTANCE;
    }

    public boolean isStereotypeDataType(EClass eClass) {
        return eClass != null && StereotypeUtil.getBaseReferences(eClass).count() > 0L;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMultiReference(EStructuralFeature feature) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EReference) {
            void ref;
            EReference eReference = (EReference)eStructuralFeature;
            EReference cfr_ignored_0 = (EReference)eStructuralFeature;
            if (ref.isMany()) {
                return true;
            }
        }
        return false;
    }
}

