/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.standalone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.ModelExporter;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;
import org.eclipse.ocl.examples.test.standalone.StandaloneTestCase;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.xtext.tests.TestCaseLogger;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.validation.PivotEAnnotationValidator;
import org.junit.Test;

public class StandaloneExecutionTests
extends StandaloneTestCase {
    protected static int EXTRA_EAnnotationValidator_SUCCESSES = PivotEAnnotationValidator.getEAnnotationValidatorRegistry() != null ? 3 : 0;

    protected static void assertNoLogFile(@NonNull String logFileName) {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertFalse((boolean)file.exists());
    }

    private @NonNull String checkExecuteResultFile(@NonNull String logFileName, @NonNull String @Nullable [] inclusions, @NonNull String @Nullable [] exclusions) throws IOException {
        int len;
        File file = new File(logFileName);
        StandaloneExecutionTests.assertTrue((boolean)file.exists());
        StringBuilder s = new StringBuilder();
        BufferedReader r = new BufferedReader(new FileReader(file));
        char[] buf = new char[4096];
        while ((len = r.read(buf)) > 0) {
            s.append(buf, 0, len);
        }
        r.close();
        String contents = s.toString();
        this.checkExecuteResults(contents, inclusions, exclusions);
        return contents;
    }

    public String checkExecuteResults(@NonNull String contents, @NonNull String @Nullable [] inclusions, @NonNull String @Nullable [] exclusions) {
        int n;
        int n2;
        String[] stringArray;
        if (inclusions != null) {
            stringArray = inclusions;
            n2 = inclusions.length;
            n = 0;
            while (n < n2) {
                String inclusion = stringArray[n];
                StandaloneExecutionTests.assertTrue((String)("Expected to find: " + inclusion), (boolean)contents.contains(inclusion));
                ++n;
            }
        }
        if (exclusions != null) {
            stringArray = exclusions;
            n2 = exclusions.length;
            n = 0;
            while (n < n2) {
                String exclusion = stringArray[n];
                StandaloneExecutionTests.assertFalse((String)("Did not expect to find: " + exclusion), (boolean)contents.contains(exclusion));
                ++n;
            }
        }
        return contents;
    }

    private @NonNull List<@NonNull String> checkValidateLogFile(@NonNull String logFileName, int oks, int infos, int warnings, int errors, int fails) throws IOException {
        File file = new File(logFileName);
        StandaloneExecutionTests.assertTrue((boolean)file.exists());
        ArrayList<@NonNull String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new FileReader(file));
        int metricsLine = 0;
        String line = r.readLine();
        while (line != null) {
            if ("==== METRICS ====".equals(line)) {
                metricsLine = lines.size();
            }
            lines.add(line);
            line = r.readLine();
        }
        r.close();
        StandaloneExecutionTests.assertEquals((String)("- Number of Success: " + oks), (String)((String)lines.get(metricsLine + 2)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Infos: " + infos), (String)((String)lines.get(metricsLine + 3)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Warnings: " + warnings), (String)((String)lines.get(metricsLine + 4)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Errors: " + errors), (String)((String)lines.get(metricsLine + 5)));
        StandaloneExecutionTests.assertEquals((String)("- Number of Failures: " + fails), (String)((String)lines.get(metricsLine + 6)));
        return lines;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AbstractPivotConstraintLocator.initialize();
    }

    @Test
    public void testStandaloneExecution_execute_model_echo_all() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"2+3\"", "result=\"5\"", "integerSymbol=\"2\"", "integerSymbol=\"5\""}, new String[]{"<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_echo_echoes() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideResult", "-hideASResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"2+3\"", "integerSymbol=\"2\""}, new String[]{"result=\"5\"", "integerSymbol=\"5\"", "<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_echo_none() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideQuery", "-hideResult", "-hideASQuery", "-hideASResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, null, new String[]{"query=\"2+3\"", "result=\"5\"", "integerSymbol=\"2\"", "integerSymbol=\"5\"", "<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_echo_models() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideQuery", "-hideResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"integerSymbol=\"2\"", "integerSymbol=\"5\""}, new String[]{"query=\"2+3\"", "result=\"5\"", "<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_echo_texts() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideASQuery", "-hideASResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"2+3\"", "result=\"5\""}, new String[]{"integerSymbol=\"2\"", "integerSymbol=\"5\"", "<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_semantic_error() throws Exception {
        String logFileName = this.getXMLLogFileName();
        String query = "Sequence{1,2}=>forAll(i:String | true)";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-hideResult", "-hideASResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"" + query + "\"", "<errors>"}, new String[]{"integerSymbol=\"2\"", "integerSymbol=\"5\""});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_syntax_error() throws Exception {
        String logFileName = this.getXMLLogFileName();
        String query = "2&3";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-hideResult", "-hideASResult", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"2&amp;3\"", "<errors>"}, new String[]{"integerSymbol=\"2\"", "integerSymbol=\"5\""});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_self_platform() throws Exception {
        String logFileName = this.getXMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "self", "-self", "platform:/resource/org.eclipse.ocl.pivot/model/Pivot.ecore#//Boolean", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"self\"", "referredElement=\"&_0;#T-pivot-Boolean\""}, new String[]{"<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_self_file_absolute() throws Exception {
        try {
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            URI inputURI = URI.createPlatformPluginURI((String)"org.eclipse.ocl.examples.xtext.tests/models/standalone/EcoreTestFile.ecore", (boolean)true);
            InputStream inputStream = standaloneApplication.getURIConverter().createInputStream(inputURI);
            assert (inputStream != null);
            TestFile testFile = this.getTestProject().getOutputFile("EcoreTestFile.ecore", inputStream);
            String logFileName = this.getXMLLogFileName();
            String testPath = String.valueOf(testFile.getFileString()) + "#//BadClass";
            String[] arguments = new String[]{"execute", "-query", "self", "-self", testPath, "-output", logFileName, "-exporter", "model"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
            StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
            this.checkExecuteResultFile(logFileName, new String[]{"query=\"self\"", "referredElement=\"&_0;#//BadClass\""}, new String[]{"<errors>"});
            standaloneApplication.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testStandaloneExecution_execute_model_self_relative() throws Exception {
        try {
            StandaloneApplication standaloneApplication = new StandaloneApplication();
            URI inputURI = URI.createPlatformPluginURI((String)"org.eclipse.ocl.examples.xtext.tests/models/standalone/EcoreTestFile.ecore", (boolean)true);
            InputStream inputStream = standaloneApplication.getURIConverter().createInputStream(inputURI);
            assert (inputStream != null);
            TestProject testProject = this.getTestProject();
            testProject.getOutputFile("EcoreTestFile.ecore", inputStream);
            String logFileName = this.getXMLLogFileName();
            String testPath = CGUtil.isMavenSurefire() ? "../../../org.eclipse.ocl.examples.xtext.tests/models/standalone/EcoreTestFile.ecore#//BadClass" : (CGUtil.isTychoSurefire() ? "../org.eclipse.ocl.examples.xtext.tests/models/standalone/EcoreTestFile.ecore#//BadClass" : String.valueOf(testProject.getName()) + "/EcoreTestFile.ecore#//BadClass");
            String[] arguments = new String[]{"execute", "-query", "self", "-self", testPath, "-output", logFileName, "-exporter", "model"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
            StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
            this.checkExecuteResultFile(logFileName, new String[]{"query=\"self\"", "referredElement=\"&_0;#//BadClass\""}, new String[]{"<errors>"});
            standaloneApplication.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testStandaloneExecution_execute_model_self_closure() throws Exception {
        String logFileName = this.getXMLLogFileName();
        String query = "self->closure(superClasses)";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-self", "platform:/resource/org.eclipse.ocl.pivot/model-gen/Pivot.oclas#/0/pivot/Class", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"" + query + "\"", "referredType=\"pivot:Class &_0;#zfDWR\"", "referredType=\"pivot:AnyType &_0;#jbMkR\"", "referredType=\"pivot:Class &_2;#t5rpa\"", "referredType=\"pivot:Class &_2;#rrwsa\"", "referredType=\"pivot:Class &_2;#MzHoc\"", "referredType=\"pivot:Class &_2;#5r5y9\"", "referredType=\"pivot:Class &_2;#pDcbe\"", "referredType=\"pivot:Class &_2;#0kVqz\""}, new String[]{"<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_self_ecore_closure() throws Exception {
        String logFileName = this.getXMLLogFileName();
        String query = "self->closure(eSuperTypes)";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-self", "platform:/resource/org.eclipse.ocl.pivot/model/Pivot.ecore#T-pivot-Class", "-hideASTypes", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"" + query + "\"", "referredElement=\"&_0;#T-pivot-Class\"", "referredElement=\"&_0;#T-pivot-Element\"", "referredElement=\"&_0;#T-pivot-NamedElement\"", "referredElement=\"&_0;#T-pivot-Namespace\"", "referredElement=\"&_0;#T-pivot-TemplateableElement\"", "referredElement=\"&_0;#T-pivot-Type\""}, new String[]{"<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_model_self_oclType_closure() throws Exception {
        String logFileName = this.getXMLLogFileName();
        String query = "self.oclType()->closure(superClasses)";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-self", "platform:/resource/org.eclipse.ocl.pivot/model/Pivot.ecore#T-pivot-Class", "-hideASTypes", "-output", logFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"query=\"" + query + "\"", "xmi:id=\"GzvN6\"", "xmi:id=\"HzvN6\"", "xmi:id=\"IzvN6\"", "xmi:id=\"JzvN6\"", "xmi:id=\"KzvN6\"", "xmi:id=\"LzvN6\""}, new String[]{"<errors>"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text() throws Exception {
        String logFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideQuery", "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"5"}, new String[]{"Query", "Result", "Error"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text_syntax_error() throws Exception {
        String logFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2&3", "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"Query : 2&3", "Result:", "Error :"}, null);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text_semantic_error() throws Exception {
        String logFileName = this.getTextLogFileName();
        String query = "Set{1,2}->forAll(i:String | true)";
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", query, "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"Query : " + query, "Result:", "Error :"}, null);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text_echo_texts() throws Exception {
        String logFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideASQuery", "-hideASResult", "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"Query : 2+3", "Result: 5"}, new String[]{"Error"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_none_echo_texts() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideASQuery", "-hideASResult"};
        StandaloneTestApplication standaloneApplication = new StandaloneTestApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        String consoleText = standaloneApplication.getConsoleText();
        assert (consoleText != null);
        this.checkExecuteResults(consoleText, new String[]{"5"}, new String[]{"Query", "Result", "Error"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text_echo_text() throws Exception {
        String logFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideResult", "-hideASQuery", "-hideASResult", "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"Query : 2+3"}, new String[]{"Result", "Error"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_execute_text_show_text() throws Exception {
        String logFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"execute", "-query", "2+3", "-hideQuery", "-output", logFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        this.checkExecuteResultFile(logFileName, new String[]{"5"}, new String[]{"Query", "Result", "Error"});
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_help() throws Exception {
        StringWriter outputStream = new StringWriter();
        Appendable savedDefaultOutputStream = StandaloneCommand.setDefaultOutputStream((Appendable)outputStream);
        @NonNull String @NonNull [] arguments = new String[]{"help"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        String s = outputStream.toString();
        assert (s.contains(StandaloneMessages.Standalone_Help));
        assert (s.contains(StandaloneMessages.HelpCommand_Help));
        assert (s.contains(StandaloneMessages.ValidateCommand_Help));
        StandaloneCommand.setDefaultOutputStream((Appendable)savedDefaultOutputStream);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_mandatoryArgumentsOnly() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI)};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_missingOutputArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-output"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_missingExporterArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-exporter"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-exporter"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_missingUsingArgument() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-using"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
            StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("Missing argument for"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("-using"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_textExportedFile() throws Exception {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", textLogFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        this.checkValidateLogFile(textLogFileName, 36 + EXTRA_EAnnotationValidator_SUCCESSES, 1, 1, 1, 0);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_modelExportedFile() throws Exception {
        String modelLogFileName = this.getLogFileName((IValidityExporter)ModelExporter.INSTANCE);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", modelLogFileName, "-exporter", "model"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI newFileURI = URI.createFileURI((String)modelLogFileName);
        Resource newResource = resourceSet.getResource(newFileURI, true);
        EObject eObject = (EObject)newResource.getContents().get(0);
        StandaloneExecutionTests.assertTrue((boolean)(eObject instanceof RootNode));
        String referenceName = newFileURI.trimFileExtension().appendFileExtension(PivotEAnnotationValidator.getEAnnotationValidatorRegistry() != null ? "referenceWithEAnnotationValidators" : "reference").appendFileExtension("validity").lastSegment();
        Resource refResource = resourceSet.getResource(StandaloneExecutionTests.getTestModelURI("models/standalone/" + referenceName), true);
        refResource.setURI(newFileURI);
        TestUtil.assertSameModel(refResource, newResource);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_htmlExportedFile() throws Exception {
        String logFileName = this.getHTMLLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", logFileName, "-exporter", "html"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertTrue((boolean)standaloneApplication.exists(logFileName));
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_unknownExporter() throws Exception {
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", this.getTextLogFileName(), "-exporter", "anotherExporterAttribute"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_nonExistentModelFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            String textLogFileName = this.getTextLogFileName();
            String[] arguments = new String[]{"validate", "-model", String.valueOf(StandaloneExecutionTests.getTestModelURI("models/nonExistentModel.ecore")), "-rules", String.valueOf(this.inputOCLURI), "-output", textLogFileName, "-exporter", "text"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
            StandaloneExecutionTests.assertNoLogFile(textLogFileName);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_nonExistentOclFile() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            String textLogFileName = this.getTextLogFileName();
            String[] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(StandaloneExecutionTests.getTestModelURI("models/nonExistentFile.ocl")), "-output", textLogFileName, "-exporter", "text"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
            this.checkValidateLogFile(textLogFileName, 30 + EXTRA_EAnnotationValidator_SUCCESSES, 0, 0, 0, 0);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("ignored"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_nonExistentOutputFolder() throws Exception {
        Iterable<Appender> savedAppenders = TestCaseLogger.INSTANCE.install();
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        try {
            String nonExistentOutputFolderPath = "nonExistent/anotherName.txt";
            String[] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.inputOCLURI), "-output", nonExistentOutputFolderPath, "-exporter", "text"};
            StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
            StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.FAIL, (Object)applicationResponse);
            StandaloneExecutionTests.assertNoLogFile(nonExistentOutputFolderPath);
            String logMessage = TestCaseLogger.INSTANCE.get();
            StandaloneExecutionTests.assertTrue((boolean)logMessage.contains("does not exist"));
        }
        finally {
            standaloneApplication.stop();
            TestCaseLogger.INSTANCE.uninstall(savedAppenders);
        }
    }

    @Test
    public void testStandaloneExecution_validate_listOfOCLFiles() throws Exception {
        String textLogFileName = this.getTextLogFileName();
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-output", textLogFileName, "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        this.checkValidateLogFile(textLogFileName, 42 + EXTRA_EAnnotationValidator_SUCCESSES, 2, 2, 2, 0);
        standaloneApplication.stop();
    }

    @Test
    public void testStandaloneExecution_validate_listOfOCLFilesToStdout() throws Exception {
        Appendable savedDefaultOutputStream = StandaloneCommand.setDefaultOutputStream((Appendable)NullAppendable.INSTANCE);
        @NonNull String @NonNull [] arguments = new String[]{"validate", "-model", String.valueOf(this.inputModelURI), "-rules", String.valueOf(this.textInputOCLURI), "-exporter", "text"};
        StandaloneApplication standaloneApplication = new StandaloneApplication();
        StandaloneResponse applicationResponse = standaloneApplication.execute(arguments);
        StandaloneExecutionTests.assertEquals((Object)StandaloneResponse.OK, (Object)applicationResponse);
        StandaloneExecutionTests.assertNoLogFile(this.getTextLogFileName());
        StandaloneCommand.setDefaultOutputStream((Appendable)savedDefaultOutputStream);
        standaloneApplication.stop();
    }

    private static final class NullAppendable
    implements Appendable {
        public static final @NonNull Appendable INSTANCE = new NullAppendable();

        private NullAppendable() {
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            return null;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            return null;
        }

        @Override
        public Appendable append(char c) throws IOException {
            return null;
        }
    }

    public static final class StandaloneTestApplication
    extends StandaloneApplication {
        public boolean isTest() {
            return true;
        }
    }
}

