/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorType;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class PivotExecutorStandardLibrary
extends ExecutableStandardLibrary {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private Map<Type, Class> typeMap = null;
    private Map<Package, Package> packageMap = null;

    public PivotExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        this.environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(BasicProjectManager.createDefaultProjectManager(), null);
        this.environmentFactory.getStandardLibrary().setDefaultStandardLibraryURI("http://www.eclipse.org/ocl/2015/Library");
        PivotTables.PACKAGE.getClass();
    }

    protected @NonNull Package createPackage(@NonNull Package domainPackage) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(domainPackage.getName());
        pivotPackage.setURI(domainPackage.getURI());
        for (Class domainType : domainPackage.getOwnedClasses()) {
            if (domainType == null) continue;
            Class pivotType = this.createType(domainType);
            pivotPackage.getOwnedClasses().add(pivotType);
        }
        return pivotPackage;
    }

    protected @NonNull Class createType(@NonNull Class domainType) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(domainType.getName());
        return pivotType;
    }

    @Override
    public @NonNull Class getClassType() {
        return this.environmentFactory.getStandardLibrary().getClassType();
    }

    @Override
    public @NonNull Class getEnumerationType() {
        return this.environmentFactory.getStandardLibrary().getEnumerationType();
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull Class type) {
        return this.environmentFactory.getMetamodelManager().getInheritance(type);
    }

    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    @Override
    public @Nullable Package getNsURIPackage(@NonNull String nsURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Operation getOclInvalidOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Property getOclInvalidProperty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getOclType(@NonNull String typeName) {
        ExecutorType type = PivotTables.PACKAGE.getOwnedClass(typeName);
        return type != null ? type.getPivotClass() : null;
    }

    protected Class getType(Type typeType) {
        if (typeType instanceof CollectionType) {
            CollectionType domainCollectionType = (CollectionType)typeType;
            return this.environmentFactory.getCompleteEnvironment().getCollectionType(domainCollectionType.getContainerType(), domainCollectionType.getElementType(), domainCollectionType.isIsNullFree(), (IntegerValue)null, (UnlimitedNaturalValue)null);
        }
        if (this.typeMap == null) {
            this.typeMap = new HashMap<Type, Class>();
        } else {
            Class type = this.typeMap.get(typeType);
            if (type != null) {
                return type;
            }
        }
        if (this.packageMap == null) {
            this.packageMap = new HashMap<Package, Package>();
        }
        Package domainPackage = ((Class)typeType).getOwningPackage();
        Package pivotPackage = this.packageMap.get(domainPackage);
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        if (pivotPackage == null) {
            String nsURI = domainPackage.getURI();
            if (nsURI != null) {
                pivotPackage = metamodelManager.getPrimaryPackage(nsURI, new String[0]);
            }
            if (pivotPackage == null) {
                pivotPackage = this.createPackage(domainPackage);
            }
        }
        @NonNull CompletePackage completePackage = metamodelManager.getCompletePackage(pivotPackage);
        return completePackage.getMemberType(typeType.getName());
    }

    public @NonNull Type getType(@NonNull EClassifier eClassifier) {
        Ecore2AS ecore2as = Ecore2AS.getAdapter(ClassUtil.nonNullEMF(eClassifier.eResource()), this.environmentFactory);
        Type pivotType = ecore2as.getCreated(Type.class, (EObject)eClassifier);
        return ClassUtil.nonNullState(pivotType);
    }
}

