/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.request;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.data.VMBreakpointData;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.request.VMRequest;

public class VMBreakpointRequest
extends VMRequest {
    private static final long serialVersionUID = -1085845926381930847L;
    private final long fBreakpointID;
    private final @NonNull ActionKind actionKind;
    private final @NonNull VMBreakpointData @Nullable [] data;

    public static @NonNull VMBreakpointRequest createAdd(@NonNull VMNewBreakpointData bpData) {
        return new VMBreakpointRequest(-1L, new VMNewBreakpointData[]{bpData}, ActionKind.ADD);
    }

    public static @NonNull VMBreakpointRequest createAdd(@NonNull VMNewBreakpointData @Nullable [] bpData) {
        return new VMBreakpointRequest(-1L, bpData, ActionKind.ADD);
    }

    public static @NonNull VMBreakpointRequest createChange(long id, @NonNull VMBreakpointData bpData) {
        return new VMBreakpointRequest(-1L, new VMBreakpointData[]{bpData}, ActionKind.CHANGE);
    }

    public static @NonNull VMBreakpointRequest createRemove(long id) {
        return new VMBreakpointRequest(id, null, ActionKind.REMOVE);
    }

    private VMBreakpointRequest(long uniqueID, @NonNull VMBreakpointData @Nullable [] data, @NonNull ActionKind actionKind) {
        this.fBreakpointID = uniqueID;
        this.data = data;
        this.actionKind = actionKind;
    }

    public long getBreakpointID() {
        return this.fBreakpointID;
    }

    public @NonNull ActionKind getActionKind() {
        return this.actionKind;
    }

    public List<VMBreakpointData> getBreakpointData() {
        VMBreakpointData[] data2 = this.data;
        if (data2 != null) {
            return Collections.unmodifiableList(Arrays.asList(data2));
        }
        return Collections.emptyList();
    }

    public @Nullable VMBreakpointData getFirstBreakpointData() {
        VMBreakpointData[] data2 = this.data;
        return data2 != null && data2.length > 0 ? data2[0] : null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(fBreakpointID:" + this.fBreakpointID + " action:" + (Object)((Object)this.actionKind) + ")";
    }

    public static enum ActionKind {
        ADD,
        REMOVE,
        CHANGE;

    }
}

