/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.ui.BaseUIActivator;
import org.eclipse.ocl.xtext.base.ui.builder.MultiValidationJob;
import org.eclipse.ocl.xtext.base.ui.builder.ValidationEntry;
import org.eclipse.xtext.ui.editor.XtextEditor;

public abstract class AbstractBuilderTests
extends XtextTestCase {
    public static int VALIDATION_TIMEOUT = 20000;

    protected @NonNull IFile createEcoreIFile(String projectName, String fileName, String testDocument) throws IOException, CoreException {
        OCL ocl = OCL.newInstance((ProjectManager)AbstractBuilderTests.getProjectMap());
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        IFile file = this.createIFile(projectName, fileName, (InputStream)inputStream);
        ocl.dispose();
        return file;
    }

    protected @NonNull IFile createIFile(String projectName, String testFile, InputStream inputStream) throws CoreException {
        IProject project = this.createProject(projectName);
        IFile file = project.getFile(testFile);
        file.create(inputStream, true, null);
        return file;
    }

    protected @NonNull IProject createProject(String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        project.open(null);
        return project;
    }

    protected void doTearDown(XtextEditor editor) {
        TestUIUtil.flushEvents();
        editor.close(false);
        TestUIUtil.flushEvents();
    }

    @Override
    protected void setUp() throws Exception {
        TestUIUtil.suppressGitPrefixPopUp();
        TestUIUtil.closeIntro();
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doValidation(@NonNull IFile file, @Nullable Class<?> exceptionClass, @Nullable List<@NonNull String> expectedMarkerTexts) {
        ValidationEntry validationEntry = new ValidationEntry(file, "org.eclipse.emf.ecore.diagnostic");
        MultiValidationJob multiValidationJob = BaseUIActivator.getMultiValidationJob();
        multiValidationJob.addValidations(Collections.singletonList(validationEntry));
        try {
            Throwable throwable = null;
            List markerDatas = null;
            ValidationEntry validationEntry2 = validationEntry;
            synchronized (validationEntry2) {
                validationEntry.wait(VALIDATION_TIMEOUT);
                throwable = validationEntry.getThrowable();
                markerDatas = validationEntry.getMarkerDatas();
            }
            if (exceptionClass != null) {
                AbstractBuilderTests.assertNotNull((String)("The expected " + exceptionClass.getName() + " exception was not thrown"), (Object)throwable);
                AbstractBuilderTests.assertTrue((String)("Expected a " + exceptionClass.getName() + " exception rather than a " + throwable.getClass().getName()), (boolean)exceptionClass.isAssignableFrom(throwable.getClass()));
            } else {
                if (throwable != null) {
                    AbstractBuilderTests.fail((String)("Unexpected exception " + throwable.toString()));
                }
                if (expectedMarkerTexts != null || markerDatas != null && markerDatas.size() > 0) {
                    ArrayList<@NonNull String> expectedTexts = expectedMarkerTexts != null ? new ArrayList<String>(expectedMarkerTexts) : new ArrayList();
                    ArrayList<@NonNull String> actualTexts = new ArrayList<String>();
                    if (markerDatas != null) {
                        for (MultiValidationJob.MarkerData markerData : markerDatas) {
                            actualTexts.add(markerData.getMessageText());
                        }
                    }
                    StringBuilder s = new StringBuilder();
                    Collections.sort(expectedTexts);
                    Collections.sort(actualTexts);
                    int iExpected = 0;
                    int iActual = 0;
                    int sizeExpected = expectedTexts.size();
                    int sizeActual = actualTexts.size();
                    while (iExpected < sizeExpected || iActual < sizeActual) {
                        String actual;
                        if (iExpected >= sizeExpected) {
                            s.append("\n\tUnexpected: " + (String)actualTexts.get(iActual));
                            ++iActual;
                            continue;
                        }
                        if (iActual >= sizeActual) {
                            s.append("\n\tMissing: " + (String)expectedTexts.get(iExpected));
                            ++iExpected;
                            continue;
                        }
                        String expected = (String)expectedTexts.get(iExpected);
                        int diff = expected.compareTo(actual = (String)actualTexts.get(iActual));
                        if (diff < 0) {
                            s.append("\n\tUnexpected: " + actual);
                            ++iActual;
                            continue;
                        }
                        if (diff > 0) {
                            s.append("\n\tMissing: " + expected);
                            ++iExpected;
                            continue;
                        }
                        ++iExpected;
                        ++iActual;
                    }
                    if (s.length() > 0) {
                        AbstractBuilderTests.fail((String)("Inconsistent MarkerData texts" + s.toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            AbstractBuilderTests.fail((String)sw.toString());
        }
    }
}

