/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Iterator;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ZOrderRequest;
import org.eclipse.ui.IWorkbenchPage;

public class ZOrderAction
extends DiagramAction {
    protected ZOrderAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public static ZOrderAction createBringToFrontAction(IWorkbenchPage workbenchPage) {
        ZOrderAction theAction = new ZOrderAction(workbenchPage);
        theAction.setId("bringToFrontAction");
        theAction.setText(DiagramUIActionsMessages.ZOrderAction_BringToFront_ActionLabelText);
        theAction.setToolTipText(DiagramUIActionsMessages.ZOrderAction_BringToFront_ActionToolTipText);
        theAction.setImageDescriptor(DiagramUIActionsPluginImages.DESC_BRING_TO_FRONT);
        theAction.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_BRING_TO_FRONT);
        return theAction;
    }

    public static ZOrderAction createBringForwardAction(IWorkbenchPage workbenchPage) {
        ZOrderAction theAction = new ZOrderAction(workbenchPage);
        theAction.setId("bringForwardAction");
        theAction.setText(DiagramUIActionsMessages.ZOrderAction_BringForward_ActionLabelText);
        theAction.setToolTipText(DiagramUIActionsMessages.ZOrderAction_BringForward_ActionToolTipText);
        theAction.setImageDescriptor(DiagramUIPluginImages.DESC_BRING_FORWARD);
        theAction.setHoverImageDescriptor(DiagramUIPluginImages.DESC_BRING_FORWARD);
        return theAction;
    }

    public static ZOrderAction createSendToBackAction(IWorkbenchPage workbenchPage) {
        ZOrderAction theAction = new ZOrderAction(workbenchPage);
        theAction.setId("sendToBackAction");
        theAction.setText(DiagramUIActionsMessages.ZOrderAction_SendToBack_ActionLabelText);
        theAction.setToolTipText(DiagramUIActionsMessages.ZOrderAction_SendToBack_ActionToolTipText);
        theAction.setImageDescriptor(DiagramUIPluginImages.DESC_SEND_TO_BACK);
        theAction.setHoverImageDescriptor(DiagramUIPluginImages.DESC_SEND_TO_BACK);
        return theAction;
    }

    public static ZOrderAction createSendBackwardAction(IWorkbenchPage workbenchPage) {
        ZOrderAction theAction = new ZOrderAction(workbenchPage);
        theAction.setId("sendBackwardAction");
        theAction.setText(DiagramUIActionsMessages.ZOrderAction_SendBackward_ActionLabelText);
        theAction.setToolTipText(DiagramUIActionsMessages.ZOrderAction_SendBackward_ActionToolTipText);
        theAction.setImageDescriptor(DiagramUIPluginImages.DESC_SEND_BACWARD);
        theAction.setHoverImageDescriptor(DiagramUIPluginImages.DESC_SEND_BACWARD);
        return theAction;
    }

    protected Request createTargetRequest() {
        return new ZOrderRequest(this.getId());
    }

    protected void updateTargetRequest() {
        ZOrderRequest theRequest = (ZOrderRequest)this.getTargetRequest();
        theRequest.setPartsToOrder(this.getOperationSet());
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Command getCommand() {
        if (this.getOperationSet().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPart editPart = (EditPart)this.getOperationSet().get(0);
        return editPart.getParent().getCommand(this.getTargetRequest());
    }

    protected boolean calculateEnabled() {
        if (this.getOperationSet().isEmpty()) {
            return false;
        }
        EditPart editPart = (EditPart)this.getOperationSet().get(0);
        GraphicalEditPart parentEditPart = (GraphicalEditPart)editPart.getParent();
        if (parentEditPart == null) {
            return false;
        }
        if (parentEditPart instanceof IEditableEditPart && !((IEditableEditPart)parentEditPart).isEditModeEnabled()) {
            return false;
        }
        if (!(parentEditPart.getContentPane().getLayoutManager() instanceof XYLayout)) {
            return false;
        }
        Iterator iter = this.getOperationSet().iterator();
        while (iter.hasNext()) {
            EditPart selectedEditPart = (EditPart)iter.next();
            if (parentEditPart != selectedEditPart.getParent()) {
                return false;
            }
            if (!(selectedEditPart instanceof IEditableEditPart) || ((IEditableEditPart)selectedEditPart).isEditModeEnabled()) continue;
            return false;
        }
        return true;
    }
}

