/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.properties.PropertiesServiceAdapterFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.DiagramPropertiesDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.DiagramPropertiesPlugin;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.util.SectionUpdateRequestCollapser;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.IReadOnlyDiagramPropertySheetPageContributor;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.PropertiesBrowserPage;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractModelerPropertySection
extends AbstractPropertySection {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    protected DemultiplexingListener eventListener = new DemultiplexingListener(this.getFilter()){

        protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
            AbstractModelerPropertySection.this.update(domain, notification);
        }
    };
    protected static final PropertiesServiceAdapterFactory propertiesProvider = new PropertiesServiceAdapterFactory();
    private boolean bIsCommandInProgress = false;
    protected static String VALUE_CHANGED_STRING = DiagramUIPropertiesMessages.AbstractPropertySection_UndoIntervalPropertyString;
    protected List input;
    protected EObject eObject;
    private List eObjectList = new ArrayList();
    protected boolean disposed = false;
    private TransactionalEditingDomain editingDomain = null;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EditingDomain theEditingDomain;
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection) || selection.equals(this.getInput())) {
            return;
        }
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        if (provider != null && (theEditingDomain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            this.setEditingDomain((TransactionalEditingDomain)theEditingDomain);
        }
        this.input = new ArrayList();
        this.eObjectList = new ArrayList();
        for (Object next : (IStructuredSelection)selection) {
            if (this.digIntoGroups() && next instanceof GroupEditPart) {
                for (Object childEP : ((GroupEditPart)next).getShapeChildren()) {
                    if (!this.addToEObjectList(childEP)) continue;
                    this.input.add(childEP);
                }
            }
            if (!this.addToEObjectList(next)) continue;
            this.input.add(next);
        }
        if (!this.eObjectList.isEmpty()) {
            this.setEObject((EObject)this.eObjectList.get(0));
        }
    }

    protected boolean digIntoGroups() {
        return false;
    }

    protected boolean addToEObjectList(Object object) {
        EObject adapted = this.unwrap(object);
        if (adapted != null) {
            this.getEObjectList().add(adapted);
            return true;
        }
        return false;
    }

    protected EObject unwrap(Object object) {
        return this.adapt(object);
    }

    protected EObject adapt(Object object) {
        if (object instanceof IAdaptable) {
            return (EObject)((IAdaptable)object).getAdapter(EObject.class);
        }
        return null;
    }

    protected boolean isCurrentSelection(Notification notification, EObject element) {
        if (element == null) {
            return false;
        }
        if (this.eObjectList.contains(element)) {
            return true;
        }
        if (this.eObjectList.size() > 0) {
            EObject eventObject = element;
            if (element instanceof EAnnotation) {
                eventObject = element.eContainer();
            } else {
                EObject container = element.eContainer();
                if (container != null && container instanceof EAnnotation) {
                    eventObject = container.eContainer();
                }
            }
            if (notification.getFeature() == EcorePackage.Literals.EANNOTATION__EMODEL_ELEMENT) {
                Object oldObj = notification.getOldValue();
                Object newObj = notification.getNewValue();
                if (oldObj instanceof EObject && newObj == null) {
                    eventObject = (EObject)oldObj;
                }
            }
            if (eventObject != element) {
                return this.eObjectList.contains(eventObject);
            }
        }
        return false;
    }

    protected void executeAsReadAction(Runnable code) {
        try {
            TransactionalEditingDomain domain = this.getEditingDomain();
            if (domain != null) {
                this.getEditingDomain().runExclusive(code);
            } else {
                code.run();
            }
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramPropertiesPlugin.getDefault(), (String)DiagramPropertiesDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeAsReadAction", (Throwable)e);
        }
    }

    protected CommandResult executeAsCompositeCommand(String actionName, List commands) {
        if (this.bIsCommandInProgress) {
            return null;
        }
        this.bIsCommandInProgress = true;
        CompositeCommand command = new CompositeCommand(actionName, commands);
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        try {
            IStatus status = history.execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            if (status.getCode() == 6 || status.getSeverity() == 8 || status.getSeverity() == 4) {
                this.refresh();
            }
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramPropertiesPlugin.getDefault(), (String)DiagramPropertiesDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeAsCompositeCommand", (Throwable)e);
            Log.error((Plugin)DiagramPropertiesPlugin.getDefault(), (int)10, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        this.bIsCommandInProgress = false;
        return command.getCommandResult();
    }

    public List getInput() {
        return this.input;
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            theEditingDomain.removeResourceSetListener((ResourceSetListener)this.getEventListener());
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            theEditingDomain.addResourceSetListener((ResourceSetListener)this.getEventListener());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.eObjectList != null) {
            this.eObjectList.clear();
        }
        this.eObject = null;
        this.disposed = true;
    }

    protected Object getPrimarySelection() {
        return this.getInput() != null && !this.getInput().isEmpty() ? this.getInput().get(0) : null;
    }

    protected EObject getEObject() {
        return this.eObject;
    }

    protected void setEObject(EObject object) {
        this.eObject = object;
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public void update(final Notification notification, final EObject element) {
        if (!this.isDisposed() && this.isCurrentSelection(notification, element) && !this.isNotifierDeleted(notification)) {
            this.postUpdateRequest(new Runnable(){

                public void run() {
                    if (!AbstractModelerPropertySection.this.isDisposed() && AbstractModelerPropertySection.this.isCurrentSelection(notification, element) && !AbstractModelerPropertySection.this.isNotifierDeleted(notification)) {
                        AbstractModelerPropertySection.this.refresh();
                    }
                }
            });
        }
    }

    protected void update(TransactionalEditingDomain domain, Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            this.update(notification, (EObject)notifier);
        }
    }

    protected boolean isNotifierDeleted(Notification notification) {
        if (!(notification.getNotifier() instanceof EObject)) {
            return false;
        }
        EObject obj = (EObject)notification.getNotifier();
        return obj.eResource() == null;
    }

    protected void postUpdateRequest(Runnable updateRequest) {
        this.getUpdateRequestCollapser().postRequest((Object)this, updateRequest);
    }

    public void handleElementModifiedEvent(Notification notification, EObject element) {
        this.update(notification, element);
    }

    protected List getEObjectList() {
        return this.eObjectList;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected DemultiplexingListener getEventListener() {
        return this.eventListener;
    }

    protected ICommand createCommand(String name, Resource res, Runnable runnable) {
        return this.createCommandInternal(name, res, runnable);
    }

    protected ICommand createCommand(String name, EObject res, Runnable runnable) {
        return this.createCommandInternal(name, res.eResource(), runnable);
    }

    private ICommand createCommandInternal(String name, Resource res, final Runnable runnable) {
        if (res == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.getEditingDomain(), name, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)res))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                runnable.run();
                return CommandResult.newOKCommandResult();
            }
        };
        return command;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            EObject eObjectInput = this.getEObject();
            if (eObjectInput != null) {
                this.editingDomain = TransactionUtil.getEditingDomain((EObject)eObjectInput);
            } else if (!this.getEObjectList().isEmpty()) {
                this.editingDomain = TransactionUtil.getEditingDomain(this.getEObjectList().get(0));
            }
        }
        return this.editingDomain;
    }

    protected void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
    }

    protected boolean isReadOnly() {
        PropertiesBrowserPage propertiesBrowserPage;
        ITabbedPropertySheetPageContributor contributor;
        return this.tabbedPropertySheetPage instanceof PropertiesBrowserPage && ((contributor = (propertiesBrowserPage = (PropertiesBrowserPage)this.tabbedPropertySheetPage).getContributor()) instanceof IReadOnlyDiagramPropertySheetPageContributor || contributor instanceof DiagramEditor && !((DiagramEditor)contributor).isWritable());
    }

    protected int getStandardLabelWidth(Composite parent, String[] labels) {
        int standardLabelWidth = 85;
        GC gc = new GC((Drawable)parent);
        int indent = gc.textExtent((String)"XXX").x;
        int i = 0;
        while (i < labels.length) {
            int width = gc.textExtent((String)labels[i]).x;
            if (width + indent > standardLabelWidth) {
                standardLabelWidth = width + indent;
            }
            ++i;
        }
        gc.dispose();
        return standardLabelWidth;
    }

    protected SectionUpdateRequestCollapser getUpdateRequestCollapser() {
        return DiagramPropertiesPlugin.getDefault().getUpdateRequestCollapser();
    }
}

