/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editors.pages;

import java.util.List;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.eef.runtime.ui.editors.pages.AbstractEEFEditorPage;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionViewer;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterDetailsBlock;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEEFMDFormPage
extends AbstractEEFEditorPage {
    public static final String PAGE_ID = "EEF-md-form-page";
    private FormEditor editor;
    protected AbstractEEFMasterDetailsBlock block;
    private IManagedForm managedForm;
    private EditingDomainViewerDropAdapter dropAdapter;

    public AbstractEEFMDFormPage(FormEditor editor, String pageTitle) {
        super(editor, PAGE_ID, pageTitle);
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.block = this.createMasterDetailsBlock();
        this.block.setEditingDomain(this.editingDomain);
        this.managedForm = managedForm;
        this.form = managedForm.getForm();
        managedForm.getToolkit().decorateFormHeading(this.form.getForm());
        this.block.createContent(managedForm);
        this.block.getMasterPart().addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractEEFMDFormPage.this.getManagedForm().fireSelectionChanged((IFormPart)AbstractEEFMDFormPage.this.block.getMasterPart(), event.getSelection());
            }
        });
        this.createContextMenuFor(this.block.getMasterPart().getModelViewer());
        this.refresh();
    }

    protected abstract AbstractEEFMasterDetailsBlock createMasterDetailsBlock();

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this.editor);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        if (this.editingDomain != null) {
            this.initDragnDrop(viewer);
        }
    }

    private void initDragnDrop(StructuredViewer viewer) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        this.dropAdapter = new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)viewer);
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)this.dropAdapter);
    }

    public IManagedForm getManagedForm() {
        return this.managedForm;
    }

    @Override
    public StructuredViewer getModelViewer() {
        if (this.block != null && this.block.getMasterPart() != null) {
            return this.block.getMasterPart().getModelViewer();
        }
        return null;
    }

    @Override
    public PropertiesEditionViewer getPropertiesViewer() {
        if (this.block != null && this.block.getLastDetailsPage() != null) {
            return this.block.getLastDetailsPage().getViewer();
        }
        return null;
    }

    @Override
    protected void refreshFormContents() {
        this.block.setAdapterFactory(this.adapterFactory);
        this.block.setEditingDomain(this.editingDomain);
        this.block.setInput(this.input);
    }

    @Override
    public void setEditingDomain(EditingDomain editingDomain) {
        super.setEditingDomain(editingDomain);
        if (this.dropAdapter == null && this.getModelViewer() != null) {
            this.initDragnDrop(this.getModelViewer());
        }
    }

    protected List<Action> additionalPageUserActions() {
        return null;
    }
}

