/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import ordersystem.Account;
import ordersystem.OrderSystemFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.DisabledConstraint;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class DisabledConstraintTest
extends TestCase {
    public void test_validate() {
        ConstraintDescriptorTest.FixtureElement config = ConstraintDescriptorTest.newFixtureConfig();
        config.putAttribute("id", "test.disabled.id");
        config.putAttribute("name", "Disabled test");
        try {
            XmlConstraintDescriptor descriptor = new XmlConstraintDescriptor((IConfigurationElement)config);
            Exception exception = new Exception();
            Account eObject = OrderSystemFactory.eINSTANCE.createAccount();
            ValidationContext ctx = new ValidationContext(eObject);
            IStatus result = new DisabledConstraint((IConstraintDescriptor)descriptor, (Throwable)exception).validate((IValidationContext)ctx);
            DisabledConstraintTest.assertTrue((boolean)(result instanceof IConstraintStatus));
            DisabledConstraintTest.assertFalse((boolean)result.isOK());
            DisabledConstraintTest.assertFalse((boolean)result.isMultiStatus());
            DisabledConstraintTest.assertTrue((boolean)descriptor.isError());
            DisabledConstraintTest.assertFalse((boolean)descriptor.isEnabled());
            DisabledConstraintTest.assertSame((Object)exception, (Object)descriptor.getException());
            descriptor.setEnabled(true);
            DisabledConstraintTest.assertFalse((boolean)descriptor.isEnabled());
        }
        catch (ConstraintExistsException e) {
            DisabledConstraintTest.fail((String)"Test constraint already exists!  Is the test being repeated?");
        }
    }

    public static class ValidationContext
    implements IValidationContext {
        private final EObject target;
        private final Set<EObject> resultLocus = new HashSet<EObject>();

        public ValidationContext(EObject target) {
            this.target = target;
            this.resultLocus.add(target);
        }

        public String getCurrentConstraintId() {
            return "test.disabled.id";
        }

        public EObject getTarget() {
            return this.target;
        }

        public EMFEventType getEventType() {
            return EMFEventType.NULL;
        }

        public List<Notification> getAllEvents() {
            return Collections.emptyList();
        }

        public EStructuralFeature getFeature() {
            return null;
        }

        public Object getFeatureNewValue() {
            return null;
        }

        public void skipCurrentConstraintFor(EObject eObject) {
        }

        public void skipCurrentConstraintForAll(Collection<?> eObjects) {
        }

        public void disableCurrentConstraint(Throwable exception) {
        }

        public Object getCurrentConstraintData() {
            return null;
        }

        public Object putCurrentConstraintData(Object newData) {
            return null;
        }

        public Set<EObject> getResultLocus() {
            return this.resultLocus;
        }

        public void addResult(EObject eObject) {
            this.resultLocus.add(eObject);
        }

        public void addResults(Collection<? extends EObject> eObjects) {
            this.resultLocus.addAll(eObjects);
        }

        public IStatus createSuccessStatus() {
            return Status.OK_STATUS;
        }

        public IStatus createFailureStatus(Object ... messageArguments) {
            return new Status(4, "org.eclipse.emf.validation.tests", 1, "", null);
        }
    }
}

