/**
 * <copyright>
 * </copyright>
 *
 * $Id: PAnnotatedEReferenceValidator.java,v 1.2 2008/01/18 06:20:57 mtaal Exp $
 */
package org.eclipse.emf.teneo.annotations.pamodel.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.teneo.annotations.pannotation.Embedded;
import org.eclipse.emf.teneo.annotations.pannotation.EmbeddedId;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToMany;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToOne;
import org.eclipse.emf.teneo.annotations.pannotation.MapKey;
import org.eclipse.emf.teneo.annotations.pannotation.OneToOne;
import org.eclipse.emf.teneo.annotations.pannotation.OrderBy;
import org.eclipse.emf.teneo.annotations.pannotation.PrimaryKeyJoinColumn;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface PAnnotatedEReferenceValidator {
	boolean validate();

	boolean validateModelEReference(EReference value);

	boolean validateAnnotatedEReference(EReference value);
	boolean validateEmbedded(Embedded value);
	boolean validateEmbeddedId(EmbeddedId value);
	boolean validateManyToMany(ManyToMany value);
	boolean validateManyToOne(ManyToOne value);
	boolean validateMapKey(MapKey value);
	boolean validateOneToOne(OneToOne value);
	boolean validateOrderBy(OrderBy value);
	boolean validatePrimaryKeyJoinColumns(EList<PrimaryKeyJoinColumn> value);
}
