/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class CDOLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider,
IFontProvider {
    public static final String[] DECORATION_PROPOSALS = new String[]{"${element}", "${id}", "${state}", "${created}", "${revised}"};
    public static final String DEFAULT_DECORATION = String.valueOf(DECORATION_PROPOSALS[0]) + " [" + DECORATION_PROPOSALS[1] + "]";
    public static final String NO_DECORATION = DECORATION_PROPOSALS[0];
    private static final String[] DECORATION_ARGS = new String[]{"{0}", "{1}", "{2}", "{3,date} {3,time}", "{4,date} {4,time}"};
    private static final Color GRAY = UIUtil.getDisplay().getSystemColor(15);
    private static final Color RED = UIUtil.getDisplay().getSystemColor(3);
    private Font bold;
    private CDOView view;
    private TreeViewer viewer;
    private String pattern;

    public CDOLabelProvider(AdapterFactory adapterFactory, CDOView view, TreeViewer viewer) {
        super(adapterFactory);
        this.view = view;
        this.viewer = viewer;
        this.bold = UIUtil.getBoldFont((Control)viewer.getControl());
        this.pattern = (String)OM.PREF_LABEL_DECORATION.getValue();
        this.pattern = ObjectUtil.equals((Object)this.pattern, (Object)NO_DECORATION) ? null : StringUtil.replace((String)this.pattern, (String[])DECORATION_PROPOSALS, (String[])DECORATION_ARGS);
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.bold.dispose();
        super.dispose();
    }

    public void notifyChanged(final Notification notification) {
        super.notifyChanged(notification);
        try {
            this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        CDOLabelProvider.this.viewer.refresh(notification.getNotifier(), true);
                    }
                    catch (Exception exception) {}
                }
            });
        }
        catch (Exception exception) {}
    }

    public String getText(Object object) {
        return this.decorateText(super.getText(object), object);
    }

    public String getColumnText(Object object, int columnIndex) {
        return this.decorateText(super.getColumnText(object, columnIndex), object);
    }

    public Color getBackground(Object object) {
        return null;
    }

    public Color getForeground(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            switch (cdoObject.cdoState()) {
                case PROXY: {
                    return GRAY;
                }
                case CONFLICT: {
                    return RED;
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }

    public Font getFont(Object object) {
        try {
            InternalCDOObject cdoObject = FSMUtil.adapt((Object)object, (CDOView)this.view);
            switch (cdoObject.cdoState()) {
                case NEW: 
                case DIRTY: 
                case CONFLICT: {
                    return this.bold;
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        return null;
    }

    protected String decorateText(String text, Object object) {
        try {
            if (this.pattern != null) {
                InternalCDOObject obj = FSMUtil.adapt((Object)object, (CDOView)this.view);
                CDORevision rev = obj.cdoRevision();
                long created = rev == null ? 0L : rev.getCreated();
                long revised = rev == null ? 0L : rev.getRevised();
                text = MessageFormat.format(this.pattern, text, obj.cdoID(), obj.cdoState(), created, revised);
            }
        }
        catch (RuntimeException runtimeException) {}
        return text;
    }
}

