/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;

public class CDOContainerFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOContainerFeatureDelta {
    private CDOID newResourceID;
    private Object newContainerID;
    private int newContainerFeatureID;

    public CDOContainerFeatureDeltaImpl(CDOID newResourceID, Object newContainerID, int newContainerFeatureID) {
        super(CONTAINER_FEATURE);
        this.newResourceID = newResourceID;
        this.newContainerID = newContainerID;
        this.newContainerFeatureID = newContainerFeatureID;
    }

    public CDOContainerFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(CONTAINER_FEATURE);
        this.newContainerFeatureID = in.readInt();
        this.newContainerID = in.readCDOID();
        this.newResourceID = in.readCDOID();
    }

    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.CONTAINER;
    }

    public CDOID getResourceID() {
        return this.newResourceID;
    }

    public Object getContainerID() {
        return this.newContainerID;
    }

    public int getContainerFeatureID() {
        return this.newContainerFeatureID;
    }

    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).setResourceID(this.newResourceID);
        ((InternalCDORevision)revision).setContainerID(this.newContainerID);
        ((InternalCDORevision)revision).setContainingFeatureID(this.newContainerFeatureID);
    }

    public void adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        this.newResourceID = (CDOID)referenceAdjuster.adjustReference(this.newResourceID);
        this.newContainerID = referenceAdjuster.adjustReference(this.newContainerID);
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        out.writeInt(this.getType().ordinal());
        out.writeInt(this.newContainerFeatureID);
        out.writeCDOID(out.getIDProvider().provideCDOID(this.newContainerID));
        out.writeCDOID(this.newResourceID);
    }

    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    public static final class ContainerFeature
    extends EStructuralFeatureImpl {
        public String toString() {
            return "CONTAINER_FEATURE";
        }
    }
}

