/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.qvtc;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.tx.Families2Persons;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePivotStandaloneSetup;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BigMDE2016_QVTc_AutomatedTests
extends TestCase {
    public static void garbageCollect() throws InterruptedException {
        int y = 0;
        while (y < 5) {
            System.gc();
            Thread.sleep(100L);
            ++y;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doTest(@NonNull PrintAndLog logger, @NonNull QVTiEnvironmentFactory environmentFactory, int testSize) throws Exception {
        List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
        QVTiTransformationExecutor generatedExecutor = new QVTiTransformationExecutor(environmentFactory, Families2Persons.class);
        Transformer transformer = generatedExecutor.getTransformer();
        transformer.getTypedModelInstance("family").addRootObjects(rootObjects);
        BigMDE2016_QVTc_AutomatedTests.garbageCollect();
        logger.printf("%9d, ", 10 * testSize);
        long startTime = System.nanoTime();
        transformer.analyzeInputResources();
        transformer.run();
        long endTime = System.nanoTime();
        logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
        @NonNull Collection rootObjects2 = transformer.getTypedModelInstance("person").getRootEObjects();
        assert (rootObjects2.size() == 9 * testSize);
    }

    public String getName() {
        return TestUtil.getName((String)super.getName());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        QVTimperativePivotStandaloneSetup.doSetup();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testQVTcCompiler_Families2Persons_CG_10K() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            this.doTest(logger, environmentFactory, 1000);
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }
}

