/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.JavaCursorContextResult;
import org.eclipse.lsp4mp.commons.JavaFileInfo;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.commons.MicroProfileInlayHintTypeSettings;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionResult;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsSettings;
import org.eclipse.lsp4mp.commons.MicroProfileJavaFileInfoParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintSettings;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.utils.JSONUtility;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.internal.core.ls.AbstractMicroProfileDelegateCommandHandler;
import org.eclipse.lsp4mp.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;

public class MicroProfileDelegateCommandHandlerForJava
extends AbstractMicroProfileDelegateCommandHandler {
    private static final String FILE_INFO_COMMAND_ID = "microprofile/java/fileInfo";
    private static final String JAVA_CODEACTION_COMMAND_ID = "microprofile/java/codeAction";
    private static final String JAVA_CODEACTION_RESOLVE_COMMAND_ID = "microprofile/java/codeActionResolve";
    private static final String JAVA_CODELENS_COMMAND_ID = "microprofile/java/codeLens";
    private static final String JAVA_INLAY_HINT_COMMAND_ID = "microprofile/java/inlayHint";
    private static final String JAVA_COMPLETION_COMMAND_ID = "microprofile/java/completion";
    private static final String JAVA_DEFINITION_COMMAND_ID = "microprofile/java/definition";
    private static final String JAVA_DIAGNOSTICS_COMMAND_ID = "microprofile/java/diagnostics";
    private static final String JAVA_HOVER_COMMAND_ID = "microprofile/java/hover";
    private static final String JAVA_WORKSPACE_SYMBOLS_ID = "microprofile/java/workspaceSymbols";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "microprofile/java/fileInfo": {
                return MicroProfileDelegateCommandHandlerForJava.getFileInfo(arguments, commandId, progress);
            }
            case "microprofile/java/codeAction": {
                return MicroProfileDelegateCommandHandlerForJava.getCodeActionForJava(arguments, commandId, progress);
            }
            case "microprofile/java/codeActionResolve": {
                return MicroProfileDelegateCommandHandlerForJava.resolveCodeActionForJava(arguments, commandId, progress);
            }
            case "microprofile/java/codeLens": {
                return MicroProfileDelegateCommandHandlerForJava.getCodeLensForJava(arguments, commandId, progress);
            }
            case "microprofile/java/inlayHint": {
                return MicroProfileDelegateCommandHandlerForJava.getInlayHintForJava(arguments, commandId, progress);
            }
            case "microprofile/java/completion": {
                return MicroProfileDelegateCommandHandlerForJava.getCompletionForJava(arguments, commandId, progress);
            }
            case "microprofile/java/definition": {
                return MicroProfileDelegateCommandHandlerForJava.getDefinitionForJava(arguments, commandId, progress);
            }
            case "microprofile/java/diagnostics": {
                return MicroProfileDelegateCommandHandlerForJava.getDiagnosticsForJava(arguments, commandId, progress);
            }
            case "microprofile/java/hover": {
                return MicroProfileDelegateCommandHandlerForJava.getHoverForJava(arguments, commandId, progress);
            }
            case "microprofile/java/workspaceSymbols": {
                return this.getWorkspaceSymbolsForJava(arguments, commandId, progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static JavaFileInfo getFileInfo(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaFileInfoParams params = MicroProfileDelegateCommandHandlerForJava.createJavaFileInfoParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().fileInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaFileInfoParams createJavaFileInfoParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaFileInfoParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaFileInfoParams.uri (java file URI)!", commandId));
        }
        MicroProfileJavaFileInfoParams params = new MicroProfileJavaFileInfoParams();
        params.setUri(javaFileUri);
        return params;
    }

    private static List<? extends CodeAction> getCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaCodeActionParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCodeActionParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().codeAction(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaCodeActionParams createMicroProfileJavaCodeActionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaCodeActionParams argument!", commandId));
        }
        TextDocumentIdentifier texdDocumentIdentifier = ArgumentUtils.getTextDocumentIdentifier(obj, "textDocument");
        if (texdDocumentIdentifier == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCodeActionParams.texdDocumentIdentifier", commandId));
        }
        Range range = ArgumentUtils.getRange(obj, "range");
        CodeActionContext context = ArgumentUtils.getCodeActionContext(obj, "context");
        boolean resourceOperationSupported = ArgumentUtils.getBoolean(obj, "resourceOperationSupported");
        boolean commandConfigurationUpdateSupported = ArgumentUtils.getBoolean(obj, "commandConfigurationUpdateSupported");
        boolean resolveSupported = ArgumentUtils.getBoolean(obj, "resolveSupported");
        MicroProfileJavaCodeActionParams params = new MicroProfileJavaCodeActionParams();
        params.setTextDocument(texdDocumentIdentifier);
        params.setRange(range);
        params.setContext(context);
        params.setResourceOperationSupported(resourceOperationSupported);
        params.setCommandConfigurationUpdateSupported(commandConfigurationUpdateSupported);
        params.setResolveSupported(resolveSupported);
        return params;
    }

    private static CodeAction resolveCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        CodeAction unresolved = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCodeActionResolveParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().resolveCodeAction(unresolved, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static CodeAction createMicroProfileJavaCodeActionResolveParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one CodeAction argument!", commandId));
        }
        CodeAction codeAction = JSONUtility.toModel(obj, CodeAction.class);
        if (codeAction == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one CodeAction argument!", commandId));
        }
        CodeActionResolveData resolveData = JSONUtility.toModel(codeAction.getData(), CodeActionResolveData.class);
        if (resolveData == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with a CodeAction that has CodeActionResolveData!", commandId));
        }
        codeAction.setData((Object)resolveData);
        return codeAction;
    }

    private static List<? extends CodeLens> getCodeLensForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaCodeLensParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCodeLensParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().codeLens(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaCodeLensParams createMicroProfileJavaCodeLensParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaCodeLensParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCodeLensParams.uri (java URI)!", commandId));
        }
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams(javaFileUri);
        params.setUrlCodeLensEnabled(ArgumentUtils.getBoolean(obj, "urlCodeLensEnabled"));
        params.setCheckServerAvailable(ArgumentUtils.getBoolean(obj, "checkServerAvailable"));
        params.setOpenURICommand(ArgumentUtils.getString(obj, "openURICommand"));
        params.setLocalServerPort(ArgumentUtils.getInt(obj, "localServerPort"));
        return params;
    }

    private static List<InlayHint> getInlayHintForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaInlayHintParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaInlayHintParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().inlayHint(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaInlayHintParams createMicroProfileJavaInlayHintParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaInlayHintParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaInlayHintParams.uri (java URI)!", commandId));
        }
        MicroProfileJavaInlayHintSettings settings = null;
        Map<String, Object> settingsObj = ArgumentUtils.getObject(obj, "settings");
        if (settingsObj != null) {
            int executionMode = ArgumentUtils.getInt(settingsObj, "mode");
            settings = new MicroProfileJavaInlayHintSettings(ExecutionMode.forValue(executionMode));
            settings.setConverters(MicroProfileDelegateCommandHandlerForJava.createInlayHintTypeSettings("converters", settingsObj));
            settings.setDefaultValues(MicroProfileDelegateCommandHandlerForJava.createInlayHintTypeSettings("defaultValues", settingsObj));
        }
        return new MicroProfileJavaInlayHintParams(javaFileUri, settings);
    }

    private static MicroProfileInlayHintTypeSettings createInlayHintTypeSettings(String fieldName, Map<String, Object> settingsObj) {
        Map obj = (Map)settingsObj.get(fieldName);
        if (obj == null) {
            return null;
        }
        boolean enabled = ArgumentUtils.getBoolean(obj, "enabled");
        MicroProfileInlayHintTypeSettings settings = new MicroProfileInlayHintTypeSettings();
        settings.setEnabled(enabled);
        return settings;
    }

    private static MicroProfileJavaCompletionResult getCompletionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaCompletionParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCompletionParams(arguments, commandId);
        CompletionList completionList = PropertiesManagerForJava.getInstance().completion(params, JDTUtilsLSImpl.getInstance(), monitor);
        JavaCursorContextResult cursorContext = PropertiesManagerForJava.getInstance().javaCursorContext(params, JDTUtilsLSImpl.getInstance(), monitor);
        return new MicroProfileJavaCompletionResult(completionList, cursorContext);
    }

    private static MicroProfileJavaCompletionParams createMicroProfileJavaCompletionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaCompletionParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCompletionParams.uri (java URI)!", commandId));
        }
        Position position = ArgumentUtils.getPosition(obj, "position");
        if (position == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCompletionParams.position (completion trigger location)!", commandId));
        }
        MicroProfileJavaCompletionParams params = new MicroProfileJavaCompletionParams(javaFileUri, position);
        return params;
    }

    private static List<MicroProfileDefinition> getDefinitionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaDefinitionParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaDefinitionParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().definition(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaDefinitionParams createMicroProfileJavaDefinitionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaDefinitionParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaDefinitionParams.uri (java URI)!", commandId));
        }
        Position hoverPosition = ArgumentUtils.getPosition(obj, "position");
        return new MicroProfileJavaDefinitionParams(javaFileUri, hoverPosition);
    }

    private static List<PublishDiagnosticsParams> getDiagnosticsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException {
        MicroProfileJavaDiagnosticsParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaDiagnosticsParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().diagnostics(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaDiagnosticsParams createMicroProfileJavaDiagnosticsParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaDiagnosticsParams argument!", commandId));
        }
        List<String> javaFileUri = ArgumentUtils.getStringList(obj, "uris");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaDiagnosticsParams.uri (java URIs)!", commandId));
        }
        MicroProfileJavaDiagnosticsSettings settings = null;
        Map<String, Object> settingsObj = ArgumentUtils.getObject(obj, "settings");
        if (settingsObj != null) {
            List<String> patterns = ArgumentUtils.getStringList(settingsObj, "patterns");
            int severity = ArgumentUtils.getInt(settingsObj, "validationValueSeverity");
            int executionMode = ArgumentUtils.getInt(settingsObj, "mode");
            settings = new MicroProfileJavaDiagnosticsSettings(patterns, severity == 0 ? null : DiagnosticSeverity.forValue((int)severity), ExecutionMode.forValue(executionMode));
        }
        return new MicroProfileJavaDiagnosticsParams(javaFileUri, settings);
    }

    private static Hover getHoverForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaHoverParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaHoverParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().hover(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaHoverParams createMicroProfileJavaHoverParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaHoverParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaHoverParams.uri (java URI)!", commandId));
        }
        Position hoverPosition = ArgumentUtils.getPosition(obj, "position");
        DocumentFormat documentFormat = DocumentFormat.PlainText;
        Number documentFormatIndex = (Number)obj.get("documentFormat");
        if (documentFormatIndex != null) {
            documentFormat = DocumentFormat.forValue(documentFormatIndex.intValue());
        }
        boolean surroundEqualsWithSpaces = (Boolean)obj.get("surroundEqualsWithSpaces");
        return new MicroProfileJavaHoverParams(javaFileUri, hoverPosition, documentFormat, surroundEqualsWithSpaces);
    }

    private List<SymbolInformation> getWorkspaceSymbolsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        String projectUri = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaWorkspaceSymbolParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().workspaceSymbols(projectUri, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static String createMicroProfileJavaWorkspaceSymbolParams(List<Object> arguments, String commandId) {
        String projectUriObj = (String)arguments.get(0);
        if (projectUriObj == null || !(projectUriObj instanceof String)) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one projectUri: String argument!", commandId));
        }
        return projectUriObj;
    }
}

