/**
* LSAT API
* No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
*
* The version of the OpenAPI document: 0.5.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/


#include "Schedule.h"
#include "Helpers.h"

#include <sstream>

namespace lsat::model
{

Schedule::Schedule()
{
    m_Name = "";
    m_SequencesIsSet = false;
    m_DependenciesIsSet = false;
    
}

void Schedule::validate() const
{
    std::stringstream msg;
    if (!validate(msg))
    {
        throw lsat::helper::ValidationException(msg.str());
    }
}

bool Schedule::validate(std::stringstream& msg) const
{
    return validate(msg, "");
}

bool Schedule::validate(std::stringstream& msg, const std::string& pathPrefix) const
{
    bool success = true;
    const std::string _pathPrefix = pathPrefix.empty() ? "Schedule" : pathPrefix;

             
    if (sequencesIsSet())
    {
        const std::vector<lsat::model::Sequence>& value = m_Sequences;
        const std::string currentValuePath = _pathPrefix + ".sequences";
                
        
        { // Recursive validation of array elements
            const std::string oldValuePath = currentValuePath;
            int i = 0;
            for (const lsat::model::Sequence& value : value)
            { 
                const std::string currentValuePath = oldValuePath + "[" + std::to_string(i) + "]";
                        
        success = value.validate(msg, currentValuePath + ".sequences") && success;
 
                i++;
            }
        }

    }
         
    if (dependenciesIsSet())
    {
        const std::vector<lsat::model::Dependency>& value = m_Dependencies;
        const std::string currentValuePath = _pathPrefix + ".dependencies";
                
        
        { // Recursive validation of array elements
            const std::string oldValuePath = currentValuePath;
            int i = 0;
            for (const lsat::model::Dependency& value : value)
            { 
                const std::string currentValuePath = oldValuePath + "[" + std::to_string(i) + "]";
                        
        success = value.validate(msg, currentValuePath + ".dependencies") && success;
 
                i++;
            }
        }

    }
    
    return success;
}

bool Schedule::operator==(const Schedule& rhs) const
{
    return
    
    
    (getName() == rhs.getName())
     &&
    
    
    ((!sequencesIsSet() && !rhs.sequencesIsSet()) || (sequencesIsSet() && rhs.sequencesIsSet() && getSequences() == rhs.getSequences())) &&
    
    
    ((!dependenciesIsSet() && !rhs.dependenciesIsSet()) || (dependenciesIsSet() && rhs.dependenciesIsSet() && getDependencies() == rhs.getDependencies()))
    
    ;
}

bool Schedule::operator!=(const Schedule& rhs) const
{
    return !(*this == rhs);
}

void to_json(nlohmann::json& j, const Schedule& o)
{
    j = nlohmann::json::object();
    j["name"] = o.m_Name;
    if(o.sequencesIsSet() || !o.m_Sequences.empty())
        j["sequences"] = o.m_Sequences;
    if(o.dependenciesIsSet() || !o.m_Dependencies.empty())
        j["dependencies"] = o.m_Dependencies;
    
}

void from_json(const nlohmann::json& j, Schedule& o)
{
    j.at("name").get_to(o.m_Name);
    if(j.find("sequences") != j.end())
    {
        j.at("sequences").get_to(o.m_Sequences);
        o.m_SequencesIsSet = true;
    } 
    if(j.find("dependencies") != j.end())
    {
        j.at("dependencies").get_to(o.m_Dependencies);
        o.m_DependenciesIsSet = true;
    } 
    
}

std::string Schedule::getName() const
{
    return m_Name;
}
void Schedule::setName(std::string const& value)
{
    m_Name = value;
}
std::vector<lsat::model::Sequence> Schedule::getSequences() const
{
    return m_Sequences;
}
void Schedule::setSequences(std::vector<lsat::model::Sequence> const& value)
{
    m_Sequences = value;
    m_SequencesIsSet = true;
}
bool Schedule::sequencesIsSet() const
{
    return m_SequencesIsSet;
}
void Schedule::unsetSequences()
{
    m_SequencesIsSet = false;
}
std::vector<lsat::model::Dependency> Schedule::getDependencies() const
{
    return m_Dependencies;
}
void Schedule::setDependencies(std::vector<lsat::model::Dependency> const& value)
{
    m_Dependencies = value;
    m_DependenciesIsSet = true;
}
bool Schedule::dependenciesIsSet() const
{
    return m_DependenciesIsSet;
}
void Schedule::unsetDependencies()
{
    m_DependenciesIsSet = false;
}


} // namespace lsat::model

