/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.ui.contentassist

import dispatching.ActivityDispatching
import dispatching.Attribute
import dispatching.HasUserAttributes
import dispatching.impl.AttributesMapEntryImpl
import java.util.Map
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.RuleCall
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class DispatchingProposalProvider extends AbstractDispatchingProposalProvider {

    override complete_AttributesMapEntry(EObject model, RuleCall rule, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {
        super.complete_AttributesMapEntry(model, rule, context, acceptor)
        val activityDispatching = EcoreUtil2.getContainerOfType(model, ActivityDispatching)
        val container = EcoreUtil2.getContainerOfType(model, HasUserAttributes)
        val attrs = newLinkedHashMap
        attrs.collectUserAttributes(activityDispatching, container.class)
        if (!attrs.empty) {
           attrs.keySet.map[name]
            .filter [ nm | container.userAttributes.keySet.findFirst[nm == name] === null]
            .forEach [
                acceptor.accept(createCompletionProposal(it + ": ", it, null, context))
            ]
        }
    }
    
    
    
    override complete_IDString(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_IDString(model, ruleCall, context, acceptor)
        complete_AttributesMapEntryValue(model,ruleCall,context,acceptor)
    }
    
    override complete_INTASString(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_INTASString(model, ruleCall, context, acceptor)
        complete_AttributesMapEntryValue(model,ruleCall,context,acceptor)
    }
    
    private def void collectUserAttributes(Map<Attribute,String> result, EObject object, Class<?> clazz){
        if( object instanceof HasUserAttributes){
            if(clazz.isInstance(object))
                object.userAttributes.forEach[result.put(key,value)]
        }
        if(object !== null) object.eContents.forEach[collectUserAttributes(result,it,clazz)]
    }
    
    private def complete_AttributesMapEntryValue(EObject model, RuleCall rule, ContentAssistContext context,
        ICompletionProposalAcceptor acceptor) {
        val activityDispatching = EcoreUtil2.getContainerOfType(model, ActivityDispatching)
        val container = EcoreUtil2.getContainerOfType(model, HasUserAttributes)
        val keyName = (model as AttributesMapEntryImpl)?.key?.name
        val attrs = newLinkedHashMap
        attrs.collectUserAttributes(activityDispatching, container.class)
        if (!attrs.empty && keyName !== null) {
            attrs.entrySet.filter[keyName==key.name].map[value].filterNull.toSet
            .forEach [
                acceptor.accept(createCompletionProposal(it.quote, it, null, context))
            ]
        }
    }
    
    private def quote(String string) {
        string.matches("(\\w)*")? string: '"' + string + '"'
    }

}
