/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.Maps;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.eclipse.elk.graph.ElkNode;

@FunctionalInterface
public interface IBoundsProvider {
    public Rectangle2D.Double boundsFor(ElkNode var1);

    default public void preprocess(ElkNode graph, boolean includeHierarchy) {
    }

    default public void cleanup() {
    }

    default public IBoundsProvider cached() {
        return new IBoundsProvider(){
            private final Map<ElkNode, Rectangle2D.Double> boundsCache = Maps.newHashMap();

            @Override
            public Rectangle2D.Double boundsFor(ElkNode node) {
                if (this.boundsCache.containsKey(node)) {
                    return this.boundsCache.get(node);
                }
                Rectangle2D.Double bounds = IBoundsProvider.this.boundsFor(node);
                this.boundsCache.put(node, bounds);
                return bounds;
            }

            @Override
            public void preprocess(ElkNode graph, boolean includeHierarchy) {
                IBoundsProvider.this.preprocess(graph, includeHierarchy);
            }

            @Override
            public void cleanup() {
                this.boundsCache.clear();
                IBoundsProvider.this.cleanup();
            }
        };
    }
}

