/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;

public class LayoutConfigurator
implements IGraphElementVisitor {
    public static final IProperty<LayoutConfigurator> ADD_LAYOUT_CONFIG = new Property("org.eclipse.elk.addLayoutConfig");
    private final Map<ElkGraphElement, MapPropertyHolder> elementOptionMap = Maps.newHashMap();
    private final Map<Class<? extends ElkGraphElement>, MapPropertyHolder> classOptionMap = Maps.newHashMap();
    private boolean clearLayout = false;
    private Predicate<Pair<ElkGraphElement, IProperty<?>>> optionFilter;

    public boolean isClearLayout() {
        return this.clearLayout;
    }

    public LayoutConfigurator setClearLayout(boolean doClearLayout) {
        this.clearLayout = doClearLayout;
        return this;
    }

    public LayoutConfigurator setFilter(Predicate<Pair<ElkGraphElement, IProperty<?>>> filter) {
        this.optionFilter = filter;
        return this;
    }

    public IPropertyHolder configure(ElkGraphElement element) {
        MapPropertyHolder result = this.elementOptionMap.get(element);
        if (result == null) {
            result = new MapPropertyHolder();
            this.elementOptionMap.put(element, result);
        }
        return result;
    }

    public IPropertyHolder getProperties(ElkGraphElement element) {
        return (IPropertyHolder)this.elementOptionMap.get(element);
    }

    public IPropertyHolder configure(Class<? extends ElkGraphElement> elementClass) {
        MapPropertyHolder result = this.classOptionMap.get(elementClass);
        if (result == null) {
            result = new MapPropertyHolder();
            this.classOptionMap.put(elementClass, result);
        }
        return result;
    }

    public IPropertyHolder getProperties(Class<? extends ElkGraphElement> elementClass) {
        return (IPropertyHolder)this.classOptionMap.get(elementClass);
    }

    @Override
    public void visit(ElkGraphElement element) {
        if (this.clearLayout) {
            element.getProperties().clear();
        }
        MapPropertyHolder classProperties = this.findClassOptions(element);
        MapPropertyHolder elementProperties = this.elementOptionMap.get(element);
        if (this.optionFilter != null) {
            if (classProperties != null) {
                for (Map.Entry entry : classProperties.getAllProperties().entrySet()) {
                    if (!this.optionFilter.apply(Pair.of(element, (IProperty)entry.getKey()))) continue;
                    element.setProperty((IProperty)entry.getKey(), entry.getValue());
                }
            }
            if (elementProperties != null) {
                for (Map.Entry entry : elementProperties.getAllProperties().entrySet()) {
                    if (!this.optionFilter.apply(Pair.of(element, (IProperty)entry.getKey()))) continue;
                    element.setProperty((IProperty)entry.getKey(), entry.getValue());
                }
            }
        } else {
            if (classProperties != null) {
                element.copyProperties((IPropertyHolder)classProperties);
            }
            if (elementProperties != null) {
                element.copyProperties((IPropertyHolder)elementProperties);
            }
        }
    }

    private MapPropertyHolder findClassOptions(ElkGraphElement element) {
        MapPropertyHolder needle = null;
        needle = this.getPropertyHolderOrDefault(element, ElkGraphElement.class, needle);
        needle = this.getPropertyHolderOrDefault(element, ElkLabel.class, needle);
        needle = this.getPropertyHolderOrDefault(element, ElkGraphElement.class, needle);
        needle = this.getPropertyHolderOrDefault(element, ElkNode.class, needle);
        needle = this.getPropertyHolderOrDefault(element, ElkPort.class, needle);
        needle = this.getPropertyHolderOrDefault(element, ElkEdge.class, needle);
        return needle;
    }

    private MapPropertyHolder getPropertyHolderOrDefault(ElkGraphElement element, Class<?> clazz, MapPropertyHolder old) {
        MapPropertyHolder holder;
        if (clazz.isAssignableFrom(element.getClass()) && (holder = this.classOptionMap.get(clazz)) != null) {
            return holder;
        }
        return old;
    }

    public LayoutConfigurator overrideWith(LayoutConfigurator other) {
        MapPropertyHolder thisHolder;
        for (Map.Entry<ElkGraphElement, MapPropertyHolder> entry : other.elementOptionMap.entrySet()) {
            thisHolder = this.elementOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.elementOptionMap.put(entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        for (Map.Entry<Object, MapPropertyHolder> entry : other.classOptionMap.entrySet()) {
            thisHolder = this.classOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.classOptionMap.put((Class)entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        this.clearLayout = other.clearLayout;
        this.optionFilter = other.optionFilter;
        return this;
    }
}

