/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.SpecNode;

public final class FileNode {
    private final File traceFile;
    private final TraceView view;
    private List<SpecNode> specs = new ArrayList<SpecNode>();

    public FileNode(File f, TraceView v) {
        this.traceFile = f;
        this.view = v;
    }

    public File getTraceFile() {
        return this.traceFile;
    }

    public TraceView getView() {
        return this.view;
    }

    public List<SpecNode> getSpecs() {
        return this.specs;
    }

    public void add(String specPath, VerificationResult res) {
        File file = new File(specPath);
        SpecNode n = null;
        for (SpecNode sn : this.specs) {
            if (!sn.getSpecFile().equals(file)) continue;
            n = sn;
            break;
        }
        if (n == null) {
            n = new SpecNode(file, this.view);
            this.specs.add(n);
        }
        n.add(res);
    }

    boolean refresh() {
        ArrayList<SpecNode> toRemoveSn = new ArrayList<SpecNode>();
        for (SpecNode sn : this.specs) {
            if (!sn.refreshSpecNode(this.traceFile.lastModified())) continue;
            toRemoveSn.add(sn);
        }
        this.specs.removeAll(toRemoveSn);
        return this.specs.isEmpty();
    }
}

