/*
 * Decompiled with CFR 0.152.
 */
package distributions.impl;

import distributions.CalculationMode;
import distributions.DistributionsFactory;
import distributions.DistributionsPackage;
import distributions.EnumeratedDistribution;
import distributions.GammaDistribution;
import distributions.LogNormalDistribution;
import distributions.NormalDistribution;
import distributions.PertDistribution;
import distributions.PoissonDistribution;
import distributions.TriangularDistribution;
import distributions.impl.EnumeratedDistributionImpl;
import distributions.impl.GammaDistributionImpl;
import distributions.impl.LogNormalDistributionImpl;
import distributions.impl.NormalDistributionImpl;
import distributions.impl.PertDistributionImpl;
import distributions.impl.PoissonDistributionImpl;
import distributions.impl.TriangularDistributionImpl;
import distributions.math.ModeDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DistributionsFactoryImpl
extends EFactoryImpl
implements DistributionsFactory {
    public static DistributionsFactory init() {
        try {
            DistributionsFactory theDistributionsFactory = (DistributionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/lsat/distributions");
            if (theDistributionsFactory != null) {
                return theDistributionsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DistributionsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createTriangularDistribution();
            }
            case 2: {
                return this.createPertDistribution();
            }
            case 3: {
                return this.createNormalDistribution();
            }
            case 4: {
                return this.createEnumeratedDistribution();
            }
            case 5: {
                return this.createGammaDistribution();
            }
            case 6: {
                return this.createPoissonDistribution();
            }
            case 7: {
                return this.createLogNormalDistribution();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createCalculationModeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createRandomGeneratorFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createModeDistributionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertCalculationModeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertRandomGeneratorToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertModeDistributionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public TriangularDistribution createTriangularDistribution() {
        TriangularDistributionImpl triangularDistribution = new TriangularDistributionImpl();
        return triangularDistribution;
    }

    @Override
    public PertDistribution createPertDistribution() {
        PertDistributionImpl pertDistribution = new PertDistributionImpl();
        return pertDistribution;
    }

    @Override
    public NormalDistribution createNormalDistribution() {
        NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
        return normalDistribution;
    }

    @Override
    public EnumeratedDistribution createEnumeratedDistribution() {
        EnumeratedDistributionImpl enumeratedDistribution = new EnumeratedDistributionImpl();
        return enumeratedDistribution;
    }

    @Override
    public GammaDistribution createGammaDistribution() {
        GammaDistributionImpl gammaDistribution = new GammaDistributionImpl();
        return gammaDistribution;
    }

    @Override
    public PoissonDistribution createPoissonDistribution() {
        PoissonDistributionImpl poissonDistribution = new PoissonDistributionImpl();
        return poissonDistribution;
    }

    @Override
    public LogNormalDistribution createLogNormalDistribution() {
        LogNormalDistributionImpl logNormalDistribution = new LogNormalDistributionImpl();
        return logNormalDistribution;
    }

    public CalculationMode createCalculationModeFromString(EDataType eDataType, String initialValue) {
        CalculationMode result = CalculationMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCalculationModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RandomGenerator createRandomGeneratorFromString(EDataType eDataType, String initialValue) {
        return (RandomGenerator)super.createFromString(eDataType, initialValue);
    }

    public String convertRandomGeneratorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ModeDistribution createModeDistributionFromString(EDataType eDataType, String initialValue) {
        return (ModeDistribution)super.createFromString(eDataType, initialValue);
    }

    public String convertModeDistributionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public DistributionsPackage getDistributionsPackage() {
        return (DistributionsPackage)this.getEPackage();
    }

    @Deprecated
    public static DistributionsPackage getPackage() {
        return DistributionsPackage.eINSTANCE;
    }
}

