/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import activity.PeripheralAction;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lsat_graph.ActionTask;
import lsat_graph.DispatchGroupTask;
import lsat_graph.PeripheralActionTask;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.MotionData;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FinalFieldsConstructor
public class AddExecutionData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddExecutionData.class);
    @Extension
    private final ITimingCalculator timingCalculator;

    public <T extends Task> TaskDependencyGraph<T> transformModel(TaskDependencyGraph<T> graph, String[] filter) throws SpecificationException, MotionException {
        LOGGER.debug("Starting transformation");
        this.addExecutionData((DirectedGraph)graph, filter);
        LOGGER.debug("Finished transformation");
        return graph;
    }

    private <T extends Task, E extends Edge> void addExecutionData(DirectedGraph<T, E> graph, String[] filter) throws SpecificationException, MotionException {
        Consumer<DirectedGraph> _function = it -> {
            try {
                this.addExecutionData((DirectedGraph)it, filter);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        graph.getSubGraphs().forEach(_function);
        Functions.Function1 _function_1 = it -> filter.length == 0 || ArrayExtensions.contains((Object[])filter, (Object)((PeripheralAction)it.getAction()).fqn());
        Consumer<PeripheralActionTask> _function_2 = it -> {
            try {
                this.doAddExecutionData((Task)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        IterableExtensions.filter((Iterable)Iterables.filter((Iterable)graph.getNodes(), PeripheralActionTask.class), (Functions.Function1)_function_1).forEach(_function_2);
    }

    private void _doAddExecutionData(DispatchGroupTask task) {
        boolean _tripleEquals;
        EMap _executionData = task.getExecutionData();
        boolean bl = _tripleEquals = _executionData == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Expected execution data to be set for task: ");
            _builder.append((Object)task);
            throw new IllegalStateException(_builder.toString());
        }
    }

    private void _doAddExecutionData(ActionTask<?> task) throws SpecificationException, MotionException {
        Set _entrySet = this.timingCalculator.calculateMotionData((Node)task.getAction()).entrySet();
        for (Map.Entry entry : _entrySet) {
            List _timeData = ((MotionData)entry.getValue()).getTimeData();
            for (double[] timeDataValues : _timeData) {
                BasicEList timeDataBigDecimal = new BasicEList();
                double[] dArray = timeDataValues;
                int n = timeDataValues.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray[n2];
                    timeDataBigDecimal.add((Object)BigDecimal.valueOf(d));
                    ++n2;
                }
                task.addExecutionData((String)entry.getKey(), (EList)timeDataBigDecimal);
            }
            List _parameterNames = ((MotionData)entry.getValue()).getParameterNames();
            for (String paramName : _parameterNames) {
                boolean _not;
                boolean _contains = task.getExecutionDataParameters().contains((Object)paramName);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                task.getExecutionDataParameters().add((Object)paramName);
            }
        }
    }

    @XbaseGenerated
    private void doAddExecutionData(Task task) throws SpecificationException, MotionException {
        if (task instanceof ActionTask) {
            this._doAddExecutionData((ActionTask)task);
            return;
        }
        if (task instanceof DispatchGroupTask) {
            this._doAddExecutionData((DispatchGroupTask)task);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task).toString());
    }

    public AddExecutionData(ITimingCalculator timingCalculator) {
        this.timingCalculator = timingCalculator;
    }
}

