/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.valgrind.launch.ExportWizardConstants;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindExportWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ValgrindExportWizard
extends Wizard
implements IExportWizard {
    private ValgrindExportWizardPage exportPage;

    public boolean performFinish() {
        File[] logs = this.exportPage.getSelectedFiles();
        IPath outputPath = this.exportPage.getOutputPath();
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(monitor -> {
                if (logs.length > 0) {
                    File outputDir = outputPath.toFile();
                    monitor.beginTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_task"), (Object)outputPath.toOSString()), logs.length);
                    for (File log : logs) {
                        monitor.subTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_subtask"), (Object)log.getName()));
                        File outLog = new File(outputDir, log.getName());
                        try (FileInputStream fis = new FileInputStream(log);
                             FileChannel inChan = fis.getChannel();
                             FileOutputStream fos = new FileOutputStream(outLog);
                             FileChannel outChan = fos.getChannel();){
                            outChan.transferFrom(inChan, 0L, inChan.size());
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IStatus status = Status.error((String)Messages.getString("ValgrindExportWizard.Export_fail"), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)ExportWizardConstants.WIZARD_TITLE, null, (IStatus)status);
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ExportWizardConstants.WIZARD_WINDOW_TITLE);
        this.exportPage = this.getWizardPage();
        this.exportPage.setDescription(ExportWizardConstants.WIZARD_DESCRIPTION);
        this.addPage((IWizardPage)this.exportPage);
    }

    private ValgrindExportWizardPage getWizardPage() {
        return new ValgrindExportWizardPage(Messages.getString("ValgrindExportWizard.Page_name"), ExportWizardConstants.WIZARD_TITLE, null);
    }
}

