/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindError;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.core.ValgrindParserUtils;

public class ValgrindCoreParser {
    private static final String AT = "at";
    private static final String BY = "by";
    private List<IValgrindMessage> messages;
    private int pid;
    private ILaunch launch;
    private ISourceLocator locator;

    public ValgrindCoreParser(File inputFile, ILaunch launch, ISourceLocator locator) throws IOException {
        this.launch = launch;
        this.locator = locator;
        Stack<IValgrindMessage> messageStack = new Stack<IValgrindMessage>();
        Stack<Integer> indentStack = new Stack<Integer>();
        this.messages = new ArrayList<IValgrindMessage>();
        try (BufferedReader br = new BufferedReader(new FileReader(inputFile));){
            String line;
            this.pid = ValgrindParserUtils.parsePID(inputFile.getName(), "valgrind_");
            while ((line = br.readLine()) != null) {
                IValgrindMessage message;
                int indent;
                line = line.replaceFirst("==([\\d:\\.]+\\s)?\\d+==|\\*\\*\\d+\\*\\*", "");
                for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
                }
                if ((line = line.trim()).isEmpty()) continue;
                if (indent == 1) {
                    message = this.getMessage(null, line);
                    this.messages.add(message);
                    messageStack.clear();
                    messageStack.push(message);
                    indentStack.clear();
                    indentStack.push(indent);
                    continue;
                }
                if (indent <= 1) continue;
                if (indentStack.isEmpty()) {
                    message = this.getMessage(null, line);
                    this.messages.add(message);
                    messageStack.clear();
                    messageStack.push(message);
                    indentStack.clear();
                    indentStack.push(1);
                    continue;
                }
                while (indent <= (Integer)indentStack.peek()) {
                    messageStack.pop();
                    indentStack.pop();
                }
                messageStack.push(this.getMessage((IValgrindMessage)messageStack.peek(), line));
                indentStack.push(indent);
            }
        }
    }

    private IValgrindMessage getMessage(IValgrindMessage message, String line) {
        if (line.startsWith(AT) || line.startsWith(BY)) {
            Object[] parsed = ValgrindParserUtils.parseFilename(line);
            String filename = (String)parsed[0];
            int lineNo = (Integer)parsed[1];
            return new ValgrindStackFrame(message, line, this.launch, this.locator, filename, lineNo);
        }
        return new ValgrindError(message, line, this.launch, this.pid);
    }

    public IValgrindMessage[] getMessages() {
        return this.messages.toArray(new IValgrindMessage[this.messages.size()]);
    }

    public ValgrindCoreParser(File inputFile, ILaunch launch) throws IOException {
        this(inputFile, launch, ValgrindCoreParser.copyLaunchSourceLocator(launch));
    }

    public static ISourceLocator copyLaunchSourceLocator(ILaunch launch) {
        if (launch == null) {
            return null;
        }
        ISourceLocator sourceLocator = launch.getSourceLocator();
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (sourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector director = (ISourceLookupDirector)sourceLocator;
            try {
                String id = director.getId();
                String memento = director.getMemento();
                IPersistableSourceLocator sourceLocatorCopy = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                if (sourceLocatorCopy instanceof IPersistableSourceLocator2) {
                    ((IPersistableSourceLocator2)sourceLocatorCopy).initializeFromMemento(memento, launchConfiguration);
                } else {
                    sourceLocatorCopy.initializeFromMemento(memento);
                }
                return sourceLocatorCopy;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return sourceLocator;
    }
}

