/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;

public class ScpClient {
    private Session session;

    public ScpClient(RemoteScriptOptions remoteOptions) throws JSchException {
        JSch jsch = new JSch();
        this.session = jsch.getSession(remoteOptions.userName, remoteOptions.hostName, 22);
        this.session.setPassword(remoteOptions.password);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
    }

    public void transfer(String fromFile, String toFile) throws IOException, JSchException {
        String rfile = toFile;
        String lfile = fromFile;
        String command = "scp -t " + rfile;
        Channel channel = this.session.openChannel("exec");
        ((ChannelExec)channel).setCommand(command);
        try (OutputStream out = channel.getOutputStream();
             InputStream in = channel.getInputStream();){
            channel.connect();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
            long filesize = new File(lfile).length();
            command = "C0644 " + filesize + " ";
            command = lfile.lastIndexOf(47) > 0 ? command + lfile.substring(lfile.lastIndexOf(47) + 1) : command + lfile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
            byte[] buf = new byte[1024];
            try (FileInputStream fis = new FileInputStream(lfile);){
                int len;
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
        }
        channel.disconnect();
        this.session.disconnect();
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }
}

