/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.wizards.graph;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.GraphingUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.Localization;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.AreaChartBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.BarChartBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.LineChartBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.PieChartBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.ScatterChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.BlockAdapter;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.ScrollAdapter;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IBlockDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IHistoricalDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphContinuousXControl;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphContinuousYControl;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphDiscreteXControl;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public final class GraphFactory {
    private static final String[] graphNames = new String[]{Localization.getString("GraphFactory.ScatterGraph"), Localization.getString("GraphFactory.LineGraph"), Localization.getString("GraphFactory.BarGraph"), Localization.getString("GraphFactory.AreaGraph"), Localization.getString("GraphFactory.PieChart")};
    private static final String[] graphDescriptions = new String[]{Localization.getString("GraphFactory.ScatterDescription"), Localization.getString("GraphFactory.LineDescription"), Localization.getString("GraphFactory.BarDescription"), Localization.getString("GraphFactory.AreaDescription"), Localization.getString("GraphFactory.PieDescription")};
    private static final Image[] graphImages = new Image[]{GraphingUIPlugin.getImageDescriptor("icons/graphs/ScatterGraph.gif").createImage(), GraphingUIPlugin.getImageDescriptor("icons/graphs/LineGraph.gif").createImage(), GraphingUIPlugin.getImageDescriptor("icons/graphs/BarGraph.gif").createImage(), GraphingUIPlugin.getImageDescriptor("icons/graphs/AreaChart.gif").createImage(), GraphingUIPlugin.getImageDescriptor("icons/graphs/PieChart.gif").createImage()};
    private static final String[] graphIDs = new String[]{"org.eclipse.linuxtools.systemtap.graphing.ui.charts.scatterchartbuilder", "org.eclipse.linuxtools.systemtap.graphing.ui.charts.linechartbuilder", "org.eclipse.linuxtools.systemtap.graphing.ui.charts.barchartbuilder", "org.eclipse.linuxtools.systemtap.graphing.ui.charts.areachartbuilder", "org.eclipse.linuxtools.systemtap.graphing.ui.charts.piechartbuilder"};

    public static String[] getAvailableGraphs(IDataSet data) {
        LinkedList<String> ids = new LinkedList<String>();
        if (data instanceof IHistoricalDataSet) {
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.scatterchartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.linechartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.areachartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.barchartbuilder");
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.piechartbuilder");
        }
        if (data instanceof IBlockDataSet) {
            if (!ids.contains("org.eclipse.linuxtools.systemtap.graphing.ui.charts.barchartbuilder")) {
                ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.barchartbuilder");
            }
            ids.add("org.eclipse.linuxtools.systemtap.graphing.ui.charts.piechartbuilder");
        }
        String[] id = new String[]{};
        return ids.toArray(id);
    }

    public static String getGraphName(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphNames[index];
        }
        return null;
    }

    public static String getGraphDescription(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphDescriptions[index];
        }
        return null;
    }

    public static Image getGraphImage(String id) {
        int index = GraphFactory.getIndex(id);
        if (index >= 0) {
            return graphImages[index];
        }
        return null;
    }

    public static boolean isMultiGraph(String id) {
        return true;
    }

    public static AbstractChartBuilder createGraph(GraphComposite comp, int style, GraphData gd, IDataSet data) {
        AbstractChartBuilder builder = null;
        switch (GraphFactory.getIndex(gd.graphID)) {
            case 0: {
                builder = new ScatterChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 1: {
                builder = new LineChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 2: {
                if (!(data instanceof IBlockDataSet) || null != gd.key) {
                    builder = new BarChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                    break;
                }
                builder = new BarChartBuilder(comp, style, gd.title, (IAdapter)new BlockAdapter((IBlockDataSet)data, gd.xSeries, gd.ySeries));
                break;
            }
            case 3: {
                builder = new AreaChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
                break;
            }
            case 4: {
                builder = new PieChartBuilder(comp, style, gd.title, (IAdapter)new ScrollAdapter((IHistoricalDataSet)data, gd.xSeries, gd.ySeries, gd.key));
            }
        }
        return builder;
    }

    public static final Composite createGraphXControl(GraphComposite comp, int style) {
        AbstractChartBuilder builder = comp.getCanvas();
        if (builder instanceof BarChartBuilder || builder instanceof PieChartBuilder) {
            return new GraphDiscreteXControl(comp, style);
        }
        return new GraphContinuousXControl(comp, style);
    }

    public static final Composite createGraphYControl(GraphComposite comp, int style) {
        AbstractChartBuilder builder = comp.getCanvas();
        if (builder instanceof PieChartBuilder) {
            return null;
        }
        return new GraphContinuousYControl(comp, style);
    }

    private static int getIndex(String id) {
        for (int i = 0; i < graphIDs.length; ++i) {
            if (!id.equals(graphIDs[i])) continue;
            return i;
        }
        return -1;
    }
}

