/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractSaveDataHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.PerfProfileView;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerfSaveSessionHandler
extends AbstractSaveDataHandler {
    public static final String DATA_EXT = "data";

    @Override
    public IPath saveData(String filename) {
        IPath newDataLoc = this.getNewDataLocation(filename, DATA_EXT);
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        URI newDataLocURI = null;
        URI defaultDataLocURI = null;
        IRemoteFileProxy proxy = null;
        try {
            newDataLocURI = new URI(newDataLoc.toPortableString());
            defaultDataLocURI = new URI(defaultDataLoc.toPortableString());
            proxy = RemoteProxyManager.getInstance().getFileProxy(newDataLocURI);
        }
        catch (URISyntaxException e) {
            this.openErroDialog(Messages.MsgProxyError, Messages.MsgProxyError, newDataLoc.lastSegment());
        }
        catch (CoreException e) {
            this.openErroDialog(Messages.MsgProxyError, Messages.MsgProxyError, newDataLoc.lastSegment());
        }
        IFileStore newDataFileStore = proxy.getResource(newDataLocURI.getPath());
        IFileStore defaultDataFileStore = proxy.getResource(defaultDataLocURI.getPath());
        if (this.canSave(newDataLoc)) {
            try {
                defaultDataFileStore.copy(newDataFileStore, 2, null);
                PerfPlugin.getDefault().setPerfProfileData(newDataLoc);
                try {
                    PerfProfileView view = (PerfProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.ProfileView");
                    view.setContentDescription(newDataLoc.toOSString());
                }
                catch (PartInitException view) {
                    // empty catch block
                }
                IFileInfo info = newDataFileStore.fetchInfo();
                info.setAttribute(2, true);
                newDataFileStore.putInfo(info, 1024, null);
                return newDataLoc;
            }
            catch (CoreException e) {
                this.openErroDialog(Messages.PerfSaveSession_failure_title, Messages.PerfSaveSession_failure_msg, newDataLoc.lastSegment());
            }
        }
        return null;
    }

    @Override
    public boolean verifyData() {
        IPath defaultDataLoc = PerfPlugin.getDefault().getPerfProfileData();
        return defaultDataLoc != null && !defaultDataLoc.isEmpty();
    }
}

