/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.gcov.parser.Arc;
import org.eclipse.linuxtools.internal.gcov.parser.Block;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoFunction;
import org.eclipse.linuxtools.internal.gcov.parser.Messages;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.utils.BEDataInputStream;
import org.eclipse.linuxtools.internal.gcov.utils.GcovStringReader;
import org.eclipse.linuxtools.internal.gcov.utils.LEDataInputStream;
import org.eclipse.osgi.util.NLS;

public class GcnoRecordsParser {
    private static final int GCOV_NOTE_MAGIC = 1734569583;
    private static final int GCOV_TAG_FUNCTION = 0x1000000;
    private static final int GCOV_TAG_BLOCKS = 0x1410000;
    private static final int GCOV_TAG_ARCS = 21168128;
    private static final int GCOV_TAG_LINES = 21299200;
    private static final int GCC_VER_810 = 1094201642;
    private static final int GCC_VER_910 = 1094267178;
    private static final int GCC_VER_1210 = 1110585632;
    private static final int GCC_VER_407 = 875575082;
    private GcnoFunction fnctn = null;
    private final ArrayList<GcnoFunction> fnctns = new ArrayList();
    private final ArrayList<SourceFile> currentAllSrcs;
    private final HashMap<String, SourceFile> sourceMap;

    public GcnoRecordsParser(HashMap<String, SourceFile> sourceMap, ArrayList<SourceFile> allSrcs) {
        this.sourceMap = sourceMap;
        this.currentAllSrcs = allSrcs;
    }

    private SourceFile findOrAdd(String fileName) {
        SourceFile newsrc = this.sourceMap.get(fileName);
        if (newsrc == null) {
            newsrc = new SourceFile(fileName, this.currentAllSrcs.size() + 1);
            this.currentAllSrcs.add(newsrc);
            this.sourceMap.put(fileName, newsrc);
        }
        return newsrc;
    }

    public void parseData(DataInput stream) throws IOException, CoreException {
        int magic = 0;
        ArrayList<Block> blocks = null;
        SourceFile source = null;
        boolean parseFirstFnctn = false;
        boolean readBytes = false;
        magic = stream.readInt();
        if (magic == 1734569583) {
            stream = new BEDataInputStream((DataInputStream)stream);
        } else {
            magic = magic >> 16 | magic << 16;
            if ((magic = (magic & 0xFF00FF) << 8 | magic >> 8 & 0xFF00FF) == 1734569583) {
                stream = new LEDataInputStream((DataInputStream)stream);
            } else {
                String message = NLS.bind((String)Messages.GcnoRecordsParser_magic_num_error, (Object)magic);
                IStatus status = Status.error((String)message);
                throw new CoreException(status);
            }
        }
        int version = stream.readInt();
        stream.readInt();
        if (version >= 1110585632) {
            stream.readInt();
            readBytes = true;
        }
        if (version >= 1094267178) {
            GcovStringReader.readString(stream, readBytes);
        }
        if (version >= 1094201642) {
            stream.readInt();
        }
        try {
            while (true) {
                int currentTag = 0;
                int tag = stream.readInt();
                int length = stream.readInt();
                if (length < 0) {
                    length = 0;
                }
                if (tag == 0x1000000) {
                    if (parseFirstFnctn) {
                        this.fnctns.add(this.fnctn);
                    }
                    long fnctnIdent = (long)stream.readInt() & 0xFFFFFFFFL;
                    long fnctnChksm = (long)stream.readInt() & 0xFFFFFFFFL;
                    if (version >= 875575082) {
                        stream.readInt();
                    }
                    String fnctnName = GcovStringReader.readString(stream, readBytes);
                    if (version >= 1094201642) {
                        stream.readInt();
                    }
                    String fnctnSrcFle = GcovStringReader.readString(stream, readBytes);
                    long fnctnFrstLnNmbr = (long)stream.readInt() & 0xFFFFFFFFL;
                    if (version >= 1094201642) {
                        stream.readInt();
                        stream.readInt();
                    }
                    if (version >= 1094267178) {
                        stream.readInt();
                    }
                    this.fnctn = new GcnoFunction(fnctnIdent, fnctnChksm, fnctnName, fnctnSrcFle, fnctnFrstLnNmbr);
                    SourceFile srcFle2 = this.findOrAdd(this.fnctn.getSrcFile());
                    if (this.fnctn.getFirstLineNmbr() >= (long)srcFle2.getNumLines()) {
                        srcFle2.setNumLines((int)this.fnctn.getFirstLineNmbr() + 1);
                    }
                    srcFle2.addFnctn(this.fnctn);
                    parseFirstFnctn = true;
                    currentTag = tag;
                    continue;
                }
                if (this.fnctn != null && tag == 0x1410000) {
                    int blkLength = length;
                    if (version >= 1094201642) {
                        blkLength = stream.readInt();
                    }
                    blocks = new ArrayList<Block>();
                    for (int i = 0; i < blkLength; ++i) {
                        Block blck;
                        if (version >= 1094201642) {
                            blck = new Block(0L);
                        } else {
                            long BlckFlag = (long)stream.readInt() & 0xFFFFFFFFL;
                            blck = new Block(BlckFlag);
                        }
                        blocks.add(blck);
                    }
                    this.fnctn.setNumBlocks(blkLength);
                    continue;
                }
                if (this.fnctn != null && tag == 21168128) {
                    boolean mark_catches = false;
                    int srcBlockIndice = stream.readInt();
                    Block srcBlk = (Block)blocks.get(srcBlockIndice);
                    int nmbrArcs = readBytes ? ((length >> 2) - 1) / 2 : (length - 1) / 2;
                    for (int i = 0; i < nmbrArcs; ++i) {
                        int dstnatnBlockIndice = stream.readInt();
                        long flag = (long)stream.readInt() & 0xFFFFFFFFL;
                        Arc arc = new Arc(srcBlockIndice, dstnatnBlockIndice, flag, blocks);
                        srcBlk.addExitArcs(arc);
                        srcBlk.incNumSuccs();
                        Block dstntnBlk = arc.getDstnatnBlock();
                        dstntnBlk.addEntryArcs(arc);
                        dstntnBlk.incNumPreds();
                        if (arc.isFake()) {
                            if (arc.getSrcBlock() != null) {
                                srcBlk = blocks.get(srcBlockIndice);
                                srcBlk.setCallSite(true);
                                arc.setCallNonReturn(true);
                                mark_catches = true;
                            } else {
                                arc.setNonLoclaReturn(true);
                                dstntnBlk.setNonLocalReturn(true);
                            }
                        }
                        if (arc.isOnTree()) continue;
                        this.fnctn.incNumCounts();
                    }
                    if (mark_catches) {
                        for (Arc a : srcBlk.getExitArcs()) {
                            if (a.isFake() || a.isFallthrough()) continue;
                            a.setIsThrow(true);
                            this.fnctn.setHasCatch(true);
                        }
                    }
                    this.fnctn.setFunctionBlocks(blocks);
                    continue;
                }
                if (this.fnctn != null && tag == 21299200) {
                    int numBlock = stream.readInt();
                    long[] lineNos = new long[length - 1];
                    int ix = 0;
                    while (true) {
                        long lineNumber;
                        if ((lineNumber = (long)stream.readInt() & 0xFFFFFFFFL) != 0L) {
                            if (ix == 0) {
                                lineNos[ix++] = 0L;
                                lineNos[ix++] = source.getIndex();
                            }
                            lineNos[ix++] = lineNumber;
                            if (lineNumber < (long)source.getNumLines()) continue;
                            source.setNumLines((int)lineNumber + 1);
                            continue;
                        }
                        String fileName = GcovStringReader.readString(stream, readBytes);
                        if (fileName.equals(Messages.GcnoRecordsParser_null_string)) break;
                        source = this.findOrAdd(fileName);
                        lineNos[ix++] = 0L;
                        lineNos[ix++] = source.getIndex();
                    }
                    this.fnctn.getFunctionBlocks().get(numBlock).setEncoding(lineNos);
                    this.fnctn.getFunctionBlocks().get(numBlock).setNumLine(ix);
                    continue;
                }
                if (currentTag != 0 && !this.isSubTag(currentTag, tag)) {
                    this.fnctn = null;
                    currentTag = 0;
                }
                stream.skipBytes(readBytes ? length : length << 2);
            }
        }
        catch (EOFException e) {
            this.fnctn.setFunctionBlocks(blocks);
            this.fnctns.add(this.fnctn);
            return;
        }
    }

    private boolean isSubTag(int tag1, int tag2) {
        int tagMask1 = tag1 - 1 ^ tag1;
        int tagMask2 = tag2 - 1 ^ tag2;
        return tagMask1 >> 8 == tagMask2 && ((tag2 ^ tag1) & ~tagMask1) == 0;
    }

    public ArrayList<GcnoFunction> getFnctns() {
        return this.fnctns;
    }
}

