/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;

public class Folder
implements Serializable {
    private static final long serialVersionUID = 5155033391199109661L;
    private final String path;
    private final ArrayList<SourceFile> srcFiles = new ArrayList();
    private int numLines = 0;
    private int linesInstrumented = 0;
    private int linesExecuted = 0;

    public Folder(String path) {
        this.path = path;
    }

    public void accumulateSourcesCounts() {
        for (SourceFile srcFile : this.srcFiles) {
            this.numLines += srcFile.getNumLines();
            this.linesInstrumented += srcFile.getLinesInstrumented();
            this.linesExecuted += srcFile.getLinesExecuted();
        }
    }

    public String getPath() {
        return this.path;
    }

    public ArrayList<SourceFile> getSrcFiles() {
        return this.srcFiles;
    }

    public void addSrcFiles(SourceFile srcFile) {
        this.srcFiles.add(srcFile);
    }

    public int getNumLines() {
        return this.numLines;
    }

    public int getLinesExecuted() {
        return this.linesExecuted;
    }

    public int getLinesInstrumented() {
        return this.linesInstrumented;
    }
}

