/*******************************************************************************
 * Copyright (c) 2007, 2018 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Red Hat Incorporated - initial API and implementation
 *******************************************************************************/
package org.eclipse.linuxtools.internal.changelog.core.editors;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;

public class GNUFileEntryDamagerRepairer extends DefaultDamagerRepairer {

    /**
     * Creates a damager/repairer that uses the given scanner. The scanner may not be <code>null</code>
     * and is assumed to return only token that carry text attributes.
     *
     * @param scanner the token scanner to be used, may not be <code>null</code>
     */
    public GNUFileEntryDamagerRepairer(ITokenScanner scanner) {
        super(scanner);
    }

    @Override
    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        // In the case of a partition with multiline rules, we will punt to
        // reparse the entire partition because we don't know if the line being
        // edited is in the middle of an area covered by a multiline rule.  In
        // such a case, we need to back up and find the start sequence of the
        // rule.  It is easiest to just reparse the whole partition.
        return partition;
    }
}
