/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codelibs.nekohtml.parsers.SAXParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.HTMLSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.HTMLSAXParserOld;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.Messages;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDevHelp {
    public static List<Path> findAllDevhelpBooks(String paths) {
        ArrayList<Path> books = new ArrayList<Path>();
        if (paths != null) {
            for (String path : paths.split(File.pathSeparator)) {
                Path p = Path.of(path, new String[0]);
                if (!Files.isDirectory(p, new LinkOption[0])) continue;
                try (Stream<Path> htmlDirs = Files.walk(p, 1, new FileVisitOption[0]);){
                    books.addAll(htmlDirs.map(dir -> dir.resolve(String.valueOf(dir.getFileName()) + ".devhelp2")).filter(Files::isReadable).toList());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return books;
    }

    public static void main(String[] args) {
        long startParse = System.currentTimeMillis();
        String devhelpDirs = "/usr/share/doc:/usr/share/gtk-doc/html:/usr/share/devhelp/books";
        List<Path> books = ParseDevHelp.findAllDevhelpBooks(devhelpDirs);
        DevHelpParser p = new DevHelpParser(books, false);
        p.parse((IProgressMonitor)new NullProgressMonitor());
        long endParse = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endParse - startParse));
        long startSerialize = System.currentTimeMillis();
        LibHoverInfo hover = p.getLibHoverInfo();
        try {
            Path location = Path.of(args[0], "org.eclipse.linuxtools.cdt.libhover", "C");
            Files.createDirectories(location, new FileAttribute[0]);
            try (OutputStream f = Files.newOutputStream(location.resolve("devhelp.libhover"), new OpenOption[0]);
                 ObjectOutputStream out = new ObjectOutputStream(f);){
                out.writeObject(hover);
            }
        }
        catch (IOException location) {
            // empty catch block
        }
        long endSerialize = System.currentTimeMillis();
        System.out.println("Parse Complete:" + (endSerialize - startSerialize));
    }

    public static class DevHelpParser {
        private final List<Path> books = new ArrayList<Path>();
        private LibHoverInfo libhover;
        private boolean debug;
        private NullEntityResolver entityResolver = new NullEntityResolver();
        private DocumentBuilderFactory factory;

        public DevHelpParser(String paths) {
            this(ParseDevHelp.findAllDevhelpBooks(paths));
        }

        public DevHelpParser(List<Path> books) {
            this(books, false);
        }

        public DevHelpParser(List<Path> books, boolean debug) {
            this.books.addAll(books);
            this.libhover = new LibHoverInfo();
            this.debug = debug;
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
        }

        public LibHoverInfo getLibHoverInfo() {
            return this.libhover;
        }

        public LibHoverInfo parse(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ParseDevHelp_ParseTask, this.books.size());
            Collections.sort(this.books);
            for (Path book : this.books) {
                if (monitor.isCanceled()) {
                    return null;
                }
                monitor.setTaskName(MessageFormat.format(Messages.ParseDevHelp_ParseFileTask, book.getParent().getFileName().toString()));
                this.parse(book.toAbsolutePath(), monitor);
                monitor.worked(1);
            }
            return this.libhover;
        }

        private void parseLinks(HashMap<String, String> funcMap, String fileName, Path path, LibHoverInfo libhover) {
            InputStream reader = null;
            SAXParser parser = null;
            try {
                reader = Files.newInputStream(path.getParent().resolve(fileName), new OpenOption[0]);
                parser = funcMap.size() == 1 && funcMap.containsKey("name") ? new HTMLSAXParser(funcMap) : new HTMLSAXParserOld(funcMap);
                try {
                    parser.parse(new InputSource(reader));
                }
                catch (FuncFoundSaxException funcFoundSaxException) {
                    // empty catch block
                }
                reader.close();
                TreeMap<String, FunctionInfo> finfos = ((DevHelpSAXParser)parser).getFunctionInfos();
                if (finfos != null) {
                    if (this.debug) {
                        System.out.println(parser.toString());
                    }
                    libhover.functions.putAll(finfos);
                }
            }
            catch (IOException finfos) {
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }

        private void parse(Path path, IProgressMonitor monitor) {
            try (InputStream stream2 = Files.newInputStream(path, new OpenOption[0]);){
                HashMap files = new HashMap();
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                builder.setEntityResolver(this.entityResolver);
                Document doc = builder.parse(stream2);
                NodeList bookNodes = doc.getElementsByTagName("book");
                for (int x = 0; x < bookNodes.getLength(); ++x) {
                    Node n = bookNodes.item(x);
                    NamedNodeMap m = n.getAttributes();
                    Node language = m.getNamedItem("language");
                    if (language == null || language.getNodeValue().equals("c")) continue;
                    return;
                }
                NodeList nl = doc.getElementsByTagName("keyword");
                for (int i = 0; i < nl.getLength(); ++i) {
                    String typeName;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    Node n = nl.item(i);
                    NamedNodeMap m = n.getAttributes();
                    Node type = m.getNamedItem("type");
                    if (type == null || !(typeName = type.getNodeValue()).equals("function")) continue;
                    Node name = m.getNamedItem("name");
                    Node link = m.getNamedItem("link");
                    if (name == null || link == null) continue;
                    String nameValue = name.getNodeValue();
                    if ((nameValue = nameValue.replaceAll("\\(.*\\);+", "").trim()).contains("::") || nameValue.startsWith("enum ") || nameValue.contains("\"")) continue;
                    String linkValue = link.getNodeValue();
                    String[] linkParts = linkValue.split("#");
                    HashMap<String, String> funcMap = (HashMap<String, String>)files.get(linkParts[0]);
                    if (funcMap == null) {
                        funcMap = new HashMap<String, String>();
                        files.put(linkParts[0], funcMap);
                    }
                    if (linkParts.length < 2) {
                        funcMap.put("name", nameValue);
                        continue;
                    }
                    funcMap.put(linkParts[1], nameValue);
                }
                for (Map.Entry entry : files.entrySet()) {
                    String fname = (String)entry.getKey();
                    HashMap funcMap = (HashMap)entry.getValue();
                    this.parseLinks(funcMap, fname, path, this.libhover);
                }
            }
            catch (FileNotFoundException stream2) {
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }

        private static final class NullEntityResolver
        implements EntityResolver {
            private NullEntityResolver() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
    }
}

