import { TextDocument } from 'vscode-languageserver-textdocument';
import { Diagnostic, DiagnosticSeverity, DiagnosticTag, Position, uinteger } from 'vscode-languageserver-types';
import { ValidationCode, ValidatorSettings } from './main';
export declare const KEYWORDS: string[];
export interface DockerfileDiagnostic extends Diagnostic {
    /**
     * Position of the instruction position in a document (zero-based).
     * This may be null if the diagnostic is not for an instruction (for
     * example, the diagnostic may be for a parser directive).
     */
    instructionLine: uinteger | null;
}
export declare class Validator {
    private document;
    private settings;
    constructor(settings?: ValidatorSettings);
    private checkDirectives;
    /**
     * Checks the arguments of the given instruction.
     *
     * @param instruction the instruction to validate
     * @param problems an array of identified problems in the document
     * @param expectedArgCount an array of expected number of arguments
     *                         for the instruction, if its length is 1
     *                         and its value is -1, any number of
     *                         arguments greater than zero is valid
     * @param validate the function to use to validate an argument
     * @param createIncompleteDiagnostic the function to use to create a diagnostic
     *                                   if the number of arguments is incorrect
     */
    private checkArguments;
    private checkVariables;
    private checkProperty;
    validate(document: TextDocument): Diagnostic[];
    /**
     * Retrieves the line numbers that corresponds to the content of
     * here-documents in the given instruction. The line numbers are
     * zero-based.
     *
     * @param instruction the instruction to check
     * @returns an array of line numbers where content of
     *          here-documents are defined
     */
    private getHeredocLines;
    private validateInstruction;
    private hasHeredocs;
    private getDestinationArgument;
    private checkDestinationIsDirectory;
    private createDuplicatesDiagnostics;
    private createDuplicateBuildStageNameDiagnostics;
    private checkJsonDestinationIsDirectory;
    private checkFlagValue;
    /**
     * Checks that the given boolean flag is valid. A boolean flag should
     * either have no value defined (--flag) or the value should
     * case-insensitively be either "true" or "false" (--flag==tRUe is
     * valid).
     */
    private checkFlagBoolean;
    private checkFlagDuration;
    private static isNumberRelated;
    private checkDuplicateFlags;
    private checkJSON;
    private checkJSONQuotes;
    private static dockerProblems;
    private static formatMessage;
    static getDiagnosticMessage_DirectiveCasing(): string;
    static getDiagnosticMessage_DirectiveEscapeDuplicated(): string;
    static getDiagnosticMessage_DirectiveEscapeInvalid(value: string): string;
    static getDiagnosticMessage_NoSourceImage(): string;
    static getDiagnosticMessage_EmptyContinuationLine(): string;
    static getDiagnosticMessage_DuplicateBuildStageName(name: string): string;
    static getDiagnosticMessage_InvalidBuildStageName(name: string): string;
    static getDiagnosticMessage_FlagAtLeastOne(flagName: string, flagValue: string): string;
    static getDiagnosticMessage_FlagDuplicate(flag: string): string;
    static getDiagnosticMessage_FlagInvalidDuration(flag: string): string;
    static getDiagnosticMessage_FlagLessThan1ms(flag: string): string;
    static getDiagnosticMessage_FlagMissingDuration(duration: string): string;
    static getDiagnosticMessage_FlagInvalidFromValue(value: string): string;
    static getDiagnosticMessage_FlagExpectedBooleanValue(flag: string, value: string): string;
    static getDiagnosticMessage_FlagMissingValue(flag: string): string;
    static getDiagnosticMessage_FlagUnknown(flag: string): string;
    static getDiagnosticMessage_FlagUnknownUnit(unit: string, duration: string): string;
    static getDiagnosticMessage_BaseNameEmpty(name: string): string;
    static getDiagnosticMessage_InvalidAs(): string;
    static getDiagnosticMessage_InvalidPort(port: string): string;
    static getDiagnosticMessage_InvalidProto(protocol: string): string;
    static getDiagnosticMessage_InvalidReferenceFormat(): string;
    static getDiagnosticMessage_InvalidSignal(signal: string): string;
    static getDiagnosticMessage_InvalidSyntax(syntax: string): string;
    static getDiagnosticMessage_InstructionExtraArgument(): string;
    static getDiagnosticMessage_InstructionMissingArgument(): string;
    static getDiagnosticMessage_ADDDestinationNotDirectory(): string;
    static getDiagnosticMessage_ADDRequiresAtLeastTwoArguments(): string;
    static getDiagnosticMessage_COPYDestinationNotDirectory(): string;
    static getDiagnosticMessage_COPYRequiresAtLeastTwoArguments(): string;
    static getDiagnosticMessage_HEALTHCHECKRequiresAtLeastOneArgument(): string;
    static getDiagnosticMessage_ENVRequiresTwoArguments(): string;
    static getDiagnosticMessage_InstructionRequiresOneOrThreeArguments(): string;
    static getDiagnosticMessage_HealthcheckNoneUnnecessaryArgument(): string;
    static getDiagnosticMessage_InstructionMultiple(instruction: string): string;
    static getDiagnosticMessage_InstructionUnknown(instruction: string): string;
    static getDiagnosticMessage_SyntaxMissingEquals(argument: string): string;
    static getDiagnosticMessage_SyntaxMissingNames(instruction: string): string;
    static getDiagnosticMessage_SyntaxMissingSingleQuote(key: string): string;
    static getDiagnosticMessage_SyntaxMissingDoubleQuote(key: string): string;
    static getDiagnosticMessage_InstructionCasing(): string;
    static getDiagnosticMessage_InstructionJSONInSingleQuotes(): string;
    static getDiagnosticMessage_OnbuildChainingDisallowed(): string;
    static getDiagnosticMessage_OnbuildTriggerDisallowed(trigger: string): string;
    static getDiagnosticMessage_VariableModifierUnsupported(variable: string, modifier: string): string;
    static getDiagnosticMessage_ShellJsonForm(): string;
    static getDiagnosticMessage_ShellRequiresOne(): string;
    static getDiagnosticMessage_DeprecatedMaintainer(): string;
    static getDiagnosticMessage_HealthcheckCmdArgumentMissing(): string;
    static getDiagnosticMessage_HealthcheckTypeUnknown(type: string): string;
    static getDiagnosticMessage_WORKDIRPathNotAbsolute(): string;
    private static createDuplicatedEscapeDirective;
    private static createInvalidEscapeDirective;
    private static createDuplicateBuildStageName;
    private static createInvalidBuildStageName;
    private static createFlagAtLeastOne;
    private static createFlagDuplicate;
    private static createFlagInvalidDuration;
    private static createFlagLessThan1ms;
    private static createFlagMissingDuration;
    private static createFlagInvalidFrom;
    private static createFlagExpectedBooleanValue;
    private static createFlagMissingValue;
    private static createUnknownAddFlag;
    private static createUnknownCopyFlag;
    private static createUnknownFromFlag;
    private static createUnknownHealthcheckFlag;
    private static createFlagUnknownUnit;
    private static createBaseNameEmpty;
    private static createInvalidAs;
    private static createInvalidPort;
    private static createInvalidProto;
    private static createInvalidReferenceFormat;
    private static createInvalidStopSignal;
    private static createInvalidSyntax;
    private static createMissingArgument;
    private static createExtraArgument;
    private static createHealthcheckNoneUnnecessaryArgument;
    private static createADDDestinationNotDirectory;
    private static createADDRequiresAtLeastTwoArguments;
    private static createCOPYDestinationNotDirectory;
    private static createCOPYRequiresAtLeastTwoArguments;
    private static createENVRequiresTwoArguments;
    private static createHEALTHCHECKRequiresAtLeastOneArgument;
    private static createHealthcheckCmdArgumentMissing;
    private static createHealthcheckTypeUnknown;
    private static createOnbuildChainingDisallowed;
    private static createOnbuildTriggerDisallowed;
    private static createShellJsonForm;
    private static createShellRequiresOne;
    private static createRequiresOneOrThreeArguments;
    private static createNoSourceImage;
    private static createSyntaxMissingEquals;
    private static createSyntaxMissingSingleQuote;
    private static createSyntaxMissingDoubleQuote;
    private static createSyntaxMissingNames;
    private static createVariableUnsupportedModifier;
    private static createUnknownInstruction;
    private static createError;
    private static createJSONInSingleQuotes;
    private static createEmptyContinuationLine;
    private createMultipleInstructions;
    private createLowercaseDirective;
    createUppercaseInstruction(instructionLine: uinteger | null, start: Position, end: Position): Diagnostic | null;
    createMaintainerDeprecated(instructionLine: uinteger | null, start: Position, end: Position): Diagnostic | null;
    private createWORKDIRNotAbsolute;
    static createWarning(instructionLine: uinteger | null, start: Position, end: Position, description: string, code?: ValidationCode, tags?: DiagnosticTag[]): Diagnostic;
    static createDiagnostic(severity: DiagnosticSeverity, instructionLine: uinteger | null, start: Position, end: Position, description: string, code?: ValidationCode, tags?: DiagnosticTag[]): DockerfileDiagnostic;
}
