(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "dockerfile-ast", "./dockerHighlight", "./docker"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) Remy Suen. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerRename = void 0;
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var dockerfile_ast_1 = require("dockerfile-ast");
    var dockerHighlight_1 = require("./dockerHighlight");
    var docker_1 = require("./docker");
    var DockerRename = /** @class */ (function () {
        function DockerRename() {
        }
        DockerRename.prototype.prepareRename = function (content, position) {
            var dockerfile = dockerfile_ast_1.DockerfileParser.parse(content);
            var image = dockerfile.getContainingImage(position);
            for (var _i = 0, _a = dockerfile.getCOPYs(); _i < _a.length; _i++) {
                var instruction = _a[_i];
                var flag = instruction.getFromFlag();
                if (flag) {
                    var range = flag.getValueRange();
                    if (docker_1.Util.isInsideRange(position, range)) {
                        return range;
                    }
                }
            }
            var fromInstructions = dockerfile.getFROMs();
            for (var _b = 0, fromInstructions_1 = fromInstructions; _b < fromInstructions_1.length; _b++) {
                var from = fromInstructions_1[_b];
                if (docker_1.Util.isInsideRange(position, from.getBuildStageRange())) {
                    return from.getBuildStageRange();
                }
                var range = from.getImageNameRange();
                if (docker_1.Util.isInsideRange(position, range)) {
                    var imageName = from.getImageName();
                    for (var _c = 0, fromInstructions_2 = fromInstructions; _c < fromInstructions_2.length; _c++) {
                        var stageCheck = fromInstructions_2[_c];
                        if (stageCheck.getBuildStage() === imageName && stageCheck.getBuildStageRange().start.line < range.start.line) {
                            return range;
                        }
                    }
                }
            }
            if (image === null) {
                return null;
            }
            for (var _d = 0, _e = image.getENVs(); _d < _e.length; _d++) {
                var env = _e[_d];
                for (var _f = 0, _g = env.getProperties(); _f < _g.length; _f++) {
                    var property = _g[_f];
                    if (docker_1.Util.isInsideRange(position, property.getNameRange())) {
                        return property.getNameRange();
                    }
                }
            }
            for (var _h = 0, _j = image.getARGs(); _h < _j.length; _h++) {
                var arg = _j[_h];
                var property = arg.getProperty();
                if (property !== null && docker_1.Util.isInsideRange(position, property.getNameRange())) {
                    return property.getNameRange();
                }
            }
            for (var _k = 0, _l = image.getInstructions(); _k < _l.length; _k++) {
                var instruction = _l[_k];
                for (var _m = 0, _o = instruction.getVariables(); _m < _o.length; _m++) {
                    var variable = _o[_m];
                    if (docker_1.Util.isInsideRange(position, variable.getNameRange())) {
                        return variable.getNameRange();
                    }
                }
                if (instruction instanceof dockerfile_ast_1.Copy || instruction instanceof dockerfile_ast_1.Run) {
                    for (var _p = 0, _q = instruction.getHeredocs(); _p < _q.length; _p++) {
                        var heredoc = _q[_p];
                        var range = heredoc.getNameRange();
                        if (docker_1.Util.isInsideRange(position, range)) {
                            return range;
                        }
                        range = heredoc.getDelimiterRange();
                        if (docker_1.Util.isInsideRange(position, range)) {
                            return range;
                        }
                    }
                }
            }
            return null;
        };
        DockerRename.prototype.rename = function (textDocument, content, position, newName) {
            var edits = [];
            var highlighter = new dockerHighlight_1.DockerHighlight();
            var highlightRanges = highlighter.computeHighlightRanges(content, position);
            for (var _i = 0, highlightRanges_1 = highlightRanges; _i < highlightRanges_1.length; _i++) {
                var highlightRange = highlightRanges_1[_i];
                edits.push(vscode_languageserver_types_1.TextEdit.replace(highlightRange.range, newName));
            }
            return edits;
        };
        return DockerRename;
    }());
    exports.DockerRename = DockerRename;
});
