/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class RNGDocumentLinkingExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void includeHrefAtFirstLevel() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\" >\n\t<include href=\"addressBook.rng\">\n\t\t<define name=\"cardContent\">\n\t\t\t<element name=\"name\">\n\t\t\t\t<text />\n\t\t\t</element>\n\t\t\t<element name=\"emailAddress\">\n\t\t\t\t<text />\n\t\t\t</element>\n\t\t</define>\n\t</include>\n</grammar>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/relaxng/main.rng", XMLAssert.dl(XMLAssert.r(1, 16, 1, 31), "src/test/resources/relaxng/addressBook.rng"));
    }

    @Test
    public void includeHrefInAnyLevel() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\" >\n\n\t<start>\n\t\t<element name=\"doc\">\n\t\t\t<zeroOrMore>\n\t\t\t\t<choice>\n\t\t\t\t\t<element name=\"p\">\n\t\t\t\t\t\t<ref name=\"inline\" />\n\t\t\t\t\t</element>\n\t\t\t\t\t<grammar>\n\t\t\t\t\t\t<include href=\"table.rng\">\n\t\t\t\t\t\t\t<define name=\"cell.content\">\n\t\t\t\t\t\t\t\t<parentRef name=\"inline\" />\n\t\t\t\t\t\t\t</define>\n\t\t\t\t\t\t</include>\n\t\t\t\t\t</grammar>\n\t\t\t\t</choice>\n\t\t\t</zeroOrMore>\n\t\t</element>\n\t</start>\n\n\t<define name=\"inline\">\n\t\t<zeroOrMore>\n\t\t\t<choice>\n\t\t\t\t<text />\n\t\t\t\t<element name=\"em\">\n\t\t\t\t\t<ref name=\"inline\" />\n\t\t\t\t</element>\n\t\t\t</choice>\n\t\t</zeroOrMore>\n\t</define>\n\n</grammar>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/relaxng/main.rng", XMLAssert.dl(XMLAssert.r(10, 21, 10, 30), "src/test/resources/relaxng/table.rng"));
    }

    @Test
    public void externalRef() throws BadLocationException {
        String xml = "<element name=\"addressBook\">\n\t<zeroOrMore>\n\t\t<element name=\"card\">\n\t\t\t<element name=\"name\">\n\t\t\t\t<text />\n\t\t\t</element>\n\t\t\t<element name=\"email\">\n\t\t\t\t<text />\n\t\t\t</element>\n\t\t\t<optional>\n\t\t\t\t<element name=\"note\">\n\t\t\t\t\t<externalRef href=\"inline.rng\" />\n\t\t\t\t</element>\n\t\t\t</optional>\n\t\t</element>\n\t</zeroOrMore>\n</element>";
        XMLAssert.testDocumentLinkFor(xml, "src/test/resources/relaxng/main.rng", XMLAssert.dl(XMLAssert.r(11, 24, 11, 34), "src/test/resources/relaxng/inline.rng"));
    }
}

