/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.List;
import org.eclipse.lemminx.utils.MarkdownConverter;
import org.eclipse.lsp4j.MarkupContent;

public class MarkupContentFactory {
    public static MarkupContent createMarkupContent(String value, String preferredKind, IMarkupKindSupport support) {
        if (value == null) {
            return null;
        }
        MarkupContent content = new MarkupContent();
        if ("markdown".equals(preferredKind) && support.canSupportMarkupKind(preferredKind)) {
            String markdown = MarkdownConverter.convert(value);
            content.setValue(markdown);
            content.setKind("markdown");
        } else {
            content.setValue(value);
            content.setKind("plaintext");
        }
        return content;
    }

    public static MarkupContent creatMarkupContent(List<String> values, IMarkupKindSupport request) {
        String kind;
        String string = kind = request.canSupportMarkupKind("markdown") ? "markdown" : "plaintext";
        if (values.size() == 1) {
            return new MarkupContent(kind, values.get(0));
        }
        StringBuilder retValue = new StringBuilder();
        for (String value : values) {
            retValue.append(value);
            if (kind.equals("markdown")) {
                retValue.append("___");
            }
            retValue.append(System.lineSeparator());
            retValue.append(System.lineSeparator());
        }
        return new MarkupContent(kind, retValue.toString());
    }

    public static interface IMarkupKindSupport {
        public boolean canSupportMarkupKind(String var1);
    }
}

