/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings;

import java.util.Objects;
import org.eclipse.lsp4j.FormattingOptions;

public class XMLFormattingOptions
extends FormattingOptions {
    public static final String DEFAULT_QUOTATION = "\"";
    private static final String SPLIT_ATTRIBUTES = "splitAttributes";
    private static final String JOIN_CDATA_LINES = "joinCDATALines";
    private static final String FORMAT_COMMENTS = "formatComments";
    private static final String JOIN_COMMENT_LINES = "joinCommentLines";
    private static final String ENABLED = "enabled";
    private static final String SPACE_BEFORE_EMPTY_CLOSE_TAG = "spaceBeforeEmptyCloseTag";
    private static final String QUOTATIONS = "quotations";
    private static final String JOIN_CONTENT_LINES = "joinContentLines";
    private static final String PRESERVED_NEWLINES = "preservedNewlines";
    public static final String DOUBLE_QUOTES_VALUE = "doubleQuotes";
    public static final String SINGLE_QUOTES_VALUE = "singleQuotes";
    private static final String PRESERVE_EMPTY_CONTENT = "preserveEmptyContent";

    public XMLFormattingOptions() {
        this(false);
    }

    public XMLFormattingOptions(boolean initializeDefaults) {
        if (initializeDefaults) {
            this.initializeDefaultSettings();
        }
    }

    public void initializeDefaultSettings() {
        this.setSplitAttributes(false);
        this.setJoinCDATALines(false);
        this.setFormatComments(true);
        this.setJoinCommentLines(false);
        this.setJoinContentLines(false);
        this.setEnabled(true);
        this.setSpaceBeforeEmptyCloseTag(true);
        this.setQuotations(DOUBLE_QUOTES_VALUE);
        this.setPreserveEmptyContent(false);
        this.setPreservedNewlines(2);
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces, boolean initializeDefaultSettings) {
        super(tabSize, insertSpaces);
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
    }

    public XMLFormattingOptions(int tabSize, boolean insertSpaces) {
        this(tabSize, insertSpaces, true);
    }

    public XMLFormattingOptions(FormattingOptions options, boolean initializeDefaultSettings) {
        if (initializeDefaultSettings) {
            this.initializeDefaultSettings();
        }
        this.merge(options);
    }

    public XMLFormattingOptions(FormattingOptions options) {
        this(options, true);
    }

    public boolean isSplitAttributes() {
        Boolean value = this.getBoolean(SPLIT_ATTRIBUTES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setSplitAttributes(boolean splitAttributes) {
        this.putBoolean(SPLIT_ATTRIBUTES, splitAttributes);
    }

    public boolean isJoinCDATALines() {
        Boolean value = this.getBoolean(JOIN_CDATA_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinCDATALines(boolean joinCDATALines) {
        this.putBoolean(JOIN_CDATA_LINES, joinCDATALines);
    }

    public boolean isFormatComments() {
        Boolean value = this.getBoolean(FORMAT_COMMENTS);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setFormatComments(boolean formatComments) {
        this.putBoolean(FORMAT_COMMENTS, formatComments);
    }

    public boolean isJoinCommentLines() {
        Boolean value = this.getBoolean(JOIN_COMMENT_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinCommentLines(boolean joinCommentLines) {
        this.putBoolean(JOIN_COMMENT_LINES, joinCommentLines);
    }

    public boolean isJoinContentLines() {
        Boolean value = this.getBoolean(JOIN_CONTENT_LINES);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setJoinContentLines(boolean joinContentLines) {
        this.putBoolean(JOIN_CONTENT_LINES, joinContentLines);
    }

    public boolean isEnabled() {
        Boolean value = this.getBoolean(ENABLED);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.putBoolean(ENABLED, enabled);
    }

    public void setSpaceBeforeEmptyCloseTag(boolean spaceBeforeEmptyCloseTag) {
        this.putBoolean(SPACE_BEFORE_EMPTY_CLOSE_TAG, spaceBeforeEmptyCloseTag);
    }

    public boolean isSpaceBeforeEmptyCloseTag() {
        Boolean value = this.getBoolean(SPACE_BEFORE_EMPTY_CLOSE_TAG);
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setQuotations(String quotations) {
        this.putString(QUOTATIONS, quotations);
    }

    public String getQuotations() {
        String value = this.getString(QUOTATIONS);
        if (value != null && this.isValidQuotations()) {
            return value;
        }
        this.setQuotations(DOUBLE_QUOTES_VALUE);
        return DOUBLE_QUOTES_VALUE;
    }

    public String getQuotationAsString() {
        return DOUBLE_QUOTES_VALUE.equals(this.getQuotations()) ? DEFAULT_QUOTATION : "'";
    }

    private boolean isValidQuotations() {
        String value = this.getString(QUOTATIONS);
        return SINGLE_QUOTES_VALUE.equals(value) || DOUBLE_QUOTES_VALUE.equals(value);
    }

    public boolean isQuotations(String quotation) {
        String value = this.getQuotations();
        return Objects.equals(value, quotation);
    }

    public void setPreserveEmptyContent(boolean spaceBeforeEmptyCloseTag) {
        this.putBoolean(PRESERVE_EMPTY_CONTENT, spaceBeforeEmptyCloseTag);
    }

    public boolean isPreserveEmptyContent() {
        Boolean value = this.getBoolean(PRESERVE_EMPTY_CONTENT);
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setPreservedNewlines(int preservedNewlines) {
        this.putNumber(PRESERVED_NEWLINES, preservedNewlines);
    }

    public int getPreservedNewlines() {
        Number value = this.getNumber(PRESERVED_NEWLINES);
        if (value != null) {
            return value.intValue();
        }
        return 2;
    }

    public XMLFormattingOptions merge(FormattingOptions formattingOptions) {
        formattingOptions.entrySet().stream().forEach(entry -> {
            String key = (String)entry.getKey();
            if (!key.equals("tabSize") && !key.equals("insertSpaces")) {
                this.put(entry.getKey(), entry.getValue());
            } else {
                this.putIfAbsent(entry.getKey(), entry.getValue());
            }
        });
        return this;
    }

    public static XMLFormattingOptions create(FormattingOptions options, FormattingOptions sharedFormattingOptions) {
        return new XMLFormattingOptions(options).merge(sharedFormattingOptions);
    }

    static enum Quotations {
        doubleQuotes,
        singleQuotes;

    }
}

