/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.io.StringReader;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.datatypes.ObjectList;
import org.eclipse.lemminx.dom.parser.Constants;
import org.eclipse.lemminx.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSDAnnotationModel {
    String appInfo;
    String documentation;

    private XSDAnnotationModel() {
    }

    public String getAppInfo() {
        return this.appInfo;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public static String getDocumentation(XSObjectList annotations) {
        return XSDAnnotationModel.getDocumentation(annotations, null);
    }

    public static String getDocumentation(XSObjectList annotations, String value) {
        if (annotations == null) {
            return "";
        }
        StringBuilder doc = new StringBuilder();
        for (Object object : annotations) {
            XSDAnnotationModel annotationModel;
            XSAnnotation annotation = null;
            if (object instanceof XSMultiValueFacet && value != null) {
                XSMultiValueFacet multiValueFacet = (XSMultiValueFacet)object;
                ObjectList enumerationValues = multiValueFacet.getEnumerationValues();
                XSObjectList annotationValues = multiValueFacet.getAnnotations();
                for (int i = 0; i < enumerationValues.getLength(); ++i) {
                    Object enumValue = enumerationValues.get(i);
                    String enumString = ((ValidatedInfo)enumValue).stringValue();
                    if (!value.equals(enumString)) continue;
                    annotation = (XSAnnotation)annotationValues.get(i);
                    break;
                }
            } else if (object instanceof XSAnnotation) {
                annotation = (XSAnnotation)object;
            }
            if ((annotationModel = XSDAnnotationModel.load(annotation)) == null) continue;
            if (annotationModel.getAppInfo() != null) {
                doc.append(annotationModel.getAppInfo());
            }
            if (annotationModel.getDocumentation() != null) {
                doc.append(annotationModel.getDocumentation());
                continue;
            }
            String annotationString = annotation.getAnnotationString();
            if (StringUtils.isEmpty(annotationString)) continue;
            doc.append(XSDAnnotationModel.getDocumentation(annotationString));
        }
        return doc.toString();
    }

    public static XSDAnnotationModel load(XSAnnotation annotation) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XSAnnotationHandler handler = new XSAnnotationHandler();
            saxParser.parse(new InputSource(new StringReader(annotation.getAnnotationString())), (DefaultHandler)handler);
            return handler.getModel();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDocumentation(String xml) {
        Matcher m = Constants.DOCUMENTATION_CONTENT.matcher(xml);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static class XSAnnotationHandler
    extends DefaultHandler {
        private static final String APPINFO_ELEMENT = "appinfo";
        private static final String DOCUMENTATION_ELEMENT = "documentation";
        private StringBuilder current;
        private final XSDAnnotationModel model = new XSDAnnotationModel();

        public XSDAnnotationModel getModel() {
            return this.model;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.endsWith(DOCUMENTATION_ELEMENT) || qName.endsWith(APPINFO_ELEMENT)) {
                this.current = new StringBuilder();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.current != null) {
                if (qName.endsWith(APPINFO_ELEMENT)) {
                    this.model.appInfo = StringUtils.normalizeSpace(this.current.toString());
                } else if (qName.endsWith(DOCUMENTATION_ELEMENT)) {
                    this.model.documentation = StringUtils.normalizeSpace(this.current.toString());
                }
                this.current = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.current != null) {
                this.current.append(ch, start, length);
            }
            super.characters(ch, start, length);
        }
    }
}

