/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.dom.DTDNotationDecl;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DOMParser {
    private static final Logger LOGGER = Logger.getLogger(DOMParser.class.getName());
    private static final DOMParser INSTANCE = new DOMParser();

    public static DOMParser getInstance() {
        return INSTANCE;
    }

    private DOMParser() {
    }

    public DOMDocument parse(String text, String uri, URIResolverExtensionManager resolverExtensionManager) {
        return this.parse(new TextDocument(text, uri), resolverExtensionManager);
    }

    public DOMDocument parse(String text, String uri, URIResolverExtensionManager resolverExtensionManager, boolean ignoreWhitespaceContent) {
        return this.parse(new TextDocument(text, uri), resolverExtensionManager, ignoreWhitespaceContent);
    }

    public DOMDocument parse(TextDocument document, URIResolverExtensionManager resolverExtensionManager) {
        return this.parse(document, resolverExtensionManager, true);
    }

    public DOMDocument parse(TextDocument document, URIResolverExtensionManager resolverExtensionManager, boolean ignoreWhitespaceContent) {
        return this.parse(document, resolverExtensionManager, ignoreWhitespaceContent, null);
    }

    public DOMDocument parse(TextDocument document, URIResolverExtensionManager resolverExtensionManager, boolean ignoreWhitespaceContent, CancelChecker monitor) {
        DOMNode curr;
        boolean isDTD = DOMUtils.isDTD(document.getUri());
        boolean inDTDInternalSubset = false;
        String text = document.getText();
        Scanner scanner = XMLScanner.createScanner(text, 0, isDTD);
        DOMDocument xmlDocument = new DOMDocument(document, resolverExtensionManager);
        xmlDocument.setCancelChecker(monitor);
        DOMNode dOMNode = curr = isDTD ? new DOMDocumentType(0, text.length()) : xmlDocument;
        if (isDTD) {
            xmlDocument.addChild(curr);
            curr.closed = true;
        }
        DOMNode lastClosed = curr;
        DOMAttr attr = null;
        int endTagOpenOffset = -1;
        String pendingAttribute = null;
        DOMText tempWhitespaceContent = null;
        boolean isInitialDeclaration = true;
        TokenType token = scanner.scan();
        while (token != TokenType.EOS) {
            if (monitor != null) {
                monitor.checkCanceled();
            }
            if (tempWhitespaceContent != null && token != TokenType.EndTagOpen) {
                tempWhitespaceContent = null;
            }
            switch (token) {
                case StartTagOpen: {
                    if (!curr.isClosed() && curr.parent != null) {
                        curr.end = scanner.getTokenOffset();
                    }
                    if (curr.isClosed() || curr.isDoctype()) {
                        curr = curr.parent;
                        inDTDInternalSubset = false;
                    }
                    DOMElement child = xmlDocument.createElement(scanner.getTokenOffset(), scanner.getTokenEnd());
                    child.startTagOpenOffset = scanner.getTokenOffset();
                    curr.addChild(child);
                    curr = child;
                    break;
                }
                case StartTag: {
                    DOMNode element = (DOMElement)curr;
                    ((DOMElement)element).tag = scanner.getTokenText();
                    curr.end = scanner.getTokenEnd();
                    break;
                }
                case StartTagClose: {
                    DOMNode element;
                    if (curr.isElement()) {
                        element = (DOMElement)curr;
                        curr.end = scanner.getTokenEnd();
                        ((DOMElement)element).startTagCloseOffset = scanner.getTokenOffset();
                        if (((DOMElement)element).getTagName() != null && DOMParser.isEmptyElement(((DOMElement)element).getTagName()) && curr.parent != null) {
                            curr.closed = true;
                            curr = curr.parent;
                        }
                    } else if (curr.isProcessingInstruction() || curr.isProlog()) {
                        element = (DOMProcessingInstruction)curr;
                        curr.end = scanner.getTokenEnd();
                        ((DOMProcessingInstruction)element).startTagClose = true;
                        if (((DOMProcessingInstruction)element).getTarget() != null && DOMParser.isEmptyElement(((DOMProcessingInstruction)element).getTarget()) && curr.parent != null) {
                            curr.closed = true;
                            curr = curr.parent;
                        }
                    }
                    curr.end = scanner.getTokenEnd();
                    break;
                }
                case EndTagOpen: {
                    if (tempWhitespaceContent != null) {
                        curr.addChild(tempWhitespaceContent);
                        tempWhitespaceContent = null;
                    }
                    endTagOpenOffset = scanner.getTokenOffset();
                    curr.end = scanner.getTokenOffset();
                    break;
                }
                case EndTag: {
                    String closeTag = scanner.getTokenText();
                    DOMNode current = curr;
                    while (!(curr.isElement() && ((DOMElement)curr).isSameTag(closeTag) || curr.parent == null)) {
                        curr.end = endTagOpenOffset;
                        curr = curr.parent;
                    }
                    if (curr != xmlDocument) {
                        curr.closed = true;
                        if (curr.isElement()) {
                            ((DOMElement)curr).endTagOpenOffset = endTagOpenOffset;
                        } else if (curr.isProcessingInstruction() || curr.isProlog()) {
                            ((DOMProcessingInstruction)curr).endTagOpenOffset = endTagOpenOffset;
                        }
                        curr.end = scanner.getTokenEnd();
                        break;
                    }
                    DOMElement element = xmlDocument.createElement(scanner.getTokenOffset() - 2, scanner.getTokenEnd());
                    element.endTagOpenOffset = endTagOpenOffset;
                    element.tag = closeTag;
                    current.addChild(element);
                    curr = element;
                    break;
                }
                case StartTagSelfClose: {
                    if (curr.parent == null) break;
                    curr.closed = true;
                    ((DOMElement)curr).selfClosed = true;
                    curr.end = scanner.getTokenEnd();
                    lastClosed = curr;
                    curr = curr.parent;
                    break;
                }
                case EndTagClose: {
                    if (curr.parent == null) break;
                    curr.end = scanner.getTokenEnd();
                    lastClosed = curr;
                    if (lastClosed.isElement()) {
                        ((DOMElement)curr).endTagCloseOffset = scanner.getTokenOffset();
                    }
                    if (curr.isDoctype()) {
                        curr.closed = true;
                    }
                    curr = curr.parent;
                    break;
                }
                case AttributeName: {
                    pendingAttribute = scanner.getTokenText();
                    attr = new DOMAttr(pendingAttribute, scanner.getTokenOffset(), scanner.getTokenOffset() + pendingAttribute.length(), curr);
                    curr.setAttributeNode(attr);
                    curr.end = scanner.getTokenEnd();
                    break;
                }
                case DelimiterAssign: {
                    if (attr == null) break;
                    attr.setValue(null, scanner.getTokenOffset(), scanner.getTokenEnd());
                    attr.setDelimiter(true);
                    break;
                }
                case AttributeValue: {
                    String value = scanner.getTokenText();
                    if (curr.hasAttributes() && attr != null) {
                        attr.setValue(value, scanner.getTokenOffset(), scanner.getTokenOffset() + value.length());
                    }
                    pendingAttribute = null;
                    attr = null;
                    curr.end = scanner.getTokenEnd();
                    break;
                }
                case CDATATagOpen: {
                    DOMCDATASection cdataNode = xmlDocument.createCDataSection(scanner.getTokenOffset(), text.length());
                    curr.addChild(cdataNode);
                    curr = cdataNode;
                    break;
                }
                case CDATAContent: {
                    DOMCDATASection cdataNode = (DOMCDATASection)curr;
                    cdataNode.startContent = scanner.getTokenOffset();
                    cdataNode.endContent = scanner.getTokenEnd();
                    curr.end = scanner.getTokenEnd();
                    break;
                }
                case CDATATagClose: {
                    curr.end = scanner.getTokenEnd();
                    curr.closed = true;
                    curr = curr.parent;
                    break;
                }
                case StartPrologOrPI: {
                    DOMProcessingInstruction prologOrPINode = xmlDocument.createProcessingInstruction(scanner.getTokenOffset(), text.length());
                    curr.addChild(prologOrPINode);
                    curr = prologOrPINode;
                    break;
                }
                case PIName: {
                    DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)curr;
                    processingInstruction.target = scanner.getTokenText();
                    processingInstruction.processingInstruction = true;
                    break;
                }
                case PrologName: {
                    DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)curr;
                    processingInstruction.target = scanner.getTokenText();
                    processingInstruction.prolog = true;
                    break;
                }
                case PIContent: {
                    DOMProcessingInstruction processingInstruction = (DOMProcessingInstruction)curr;
                    processingInstruction.startContent = scanner.getTokenOffset();
                    processingInstruction.endContent = scanner.getTokenEnd();
                    break;
                }
                case PIEnd: 
                case PrologEnd: {
                    curr.end = scanner.getTokenEnd();
                    curr.closed = true;
                    curr = curr.parent;
                    break;
                }
                case StartCommentTag: {
                    if (xmlDocument.isDTD() || inDTDInternalSubset) {
                        while (!curr.isDoctype()) {
                            curr = curr.parent;
                        }
                    } else if (curr.isClosed()) {
                        curr = curr.parent;
                    }
                    DOMComment comment = xmlDocument.createComment(scanner.getTokenOffset(), text.length());
                    curr.addChild(comment);
                    curr = comment;
                    try {
                        int endLine = document.positionAt(lastClosed.end).getLine();
                        int startLine = document.positionAt(curr.start).getLine();
                        if (endLine != startLine || lastClosed.end > curr.start) break;
                        comment.commentSameLineEndTag = true;
                    }
                    catch (BadLocationException e) {
                        LOGGER.log(Level.SEVERE, "XMLParser StartCommentTag bad offset in document", e);
                    }
                    break;
                }
                case Comment: {
                    DOMComment comment = (DOMComment)curr;
                    comment.startContent = scanner.getTokenOffset();
                    comment.endContent = scanner.getTokenEnd();
                    break;
                }
                case EndCommentTag: {
                    curr.end = scanner.getTokenEnd();
                    curr.closed = true;
                    curr = curr.parent;
                    break;
                }
                case Content: {
                    boolean currIsDeclNode = curr instanceof DTDDeclNode;
                    if (currIsDeclNode) {
                        curr.end = scanner.getTokenOffset() - 1;
                        while (!curr.isDoctype()) {
                            curr = curr.getParentNode();
                        }
                    }
                    int start = scanner.getTokenOffset();
                    int end = scanner.getTokenEnd();
                    DOMText textNode = xmlDocument.createText(start, end);
                    textNode.closed = true;
                    String content = scanner.getTokenText();
                    if (StringUtils.isWhitespace(content)) {
                        if (ignoreWhitespaceContent) {
                            if (curr.hasChildNodes()) break;
                            tempWhitespaceContent = textNode;
                            break;
                        }
                        if (currIsDeclNode) break;
                        textNode.setWhitespace(true);
                    }
                    curr.addChild(textNode);
                    break;
                }
                case DTDStartDoctypeTag: {
                    DOMDocumentType doctype = xmlDocument.createDocumentType(scanner.getTokenOffset(), text.length());
                    curr.addChild(doctype);
                    doctype.parent = curr;
                    curr = doctype;
                    break;
                }
                case DTDDoctypeName: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDDocTypeKindPUBLIC: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setKind(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDDocTypeKindSYSTEM: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setKind(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDDoctypePublicId: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setPublicId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDDoctypeSystemId: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setSystemId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDStartInternalSubset: {
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setStartInternalSubset(scanner.getTokenOffset());
                    inDTDInternalSubset = true;
                    break;
                }
                case DTDEndInternalSubset: {
                    while (!curr.isDoctype()) {
                        curr.end = scanner.getTokenOffset() - 1;
                        curr = curr.getParentNode();
                    }
                    inDTDInternalSubset = false;
                    DOMDocumentType doctype = (DOMDocumentType)curr;
                    doctype.setEndInternalSubset(scanner.getTokenEnd());
                    break;
                }
                case DTDStartElement: {
                    while (!curr.isDoctype()) {
                        curr.end = scanner.getTokenOffset();
                        curr = curr.getParentNode();
                    }
                    DTDElementDecl child = new DTDElementDecl(scanner.getTokenOffset(), text.length());
                    curr.addChild(child);
                    curr = child;
                    break;
                }
                case DTDElementDeclName: {
                    DTDElementDecl element = (DTDElementDecl)curr;
                    element.setName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDElementCategory: {
                    DTDElementDecl element = (DTDElementDecl)curr;
                    element.setCategory(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDStartElementContent: {
                    DTDElementDecl element = (DTDElementDecl)curr;
                    element.setContent(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDElementContent: {
                    DTDElementDecl element = (DTDElementDecl)curr;
                    element.updateLastParameterEnd(scanner.getTokenEnd());
                    break;
                }
                case DTDEndElementContent: {
                    DTDElementDecl element = (DTDElementDecl)curr;
                    element.updateLastParameterEnd(scanner.getTokenEnd());
                    break;
                }
                case DTDStartAttlist: {
                    while (!curr.isDoctype()) {
                        curr.end = scanner.getTokenOffset();
                        curr = curr.getParentNode();
                    }
                    DTDAttlistDecl child = new DTDAttlistDecl(scanner.getTokenOffset(), text.length());
                    isInitialDeclaration = true;
                    curr.addChild(child);
                    curr = child;
                    break;
                }
                case DTDAttlistElementName: {
                    DTDAttlistDecl attribute = (DTDAttlistDecl)curr;
                    attribute.setName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDAttlistAttributeName: {
                    DTDAttlistDecl attribute = (DTDAttlistDecl)curr;
                    if (!isInitialDeclaration) {
                        DTDAttlistDecl child = new DTDAttlistDecl(attribute.getStart(), attribute.getEnd());
                        attribute.addAdditionalAttDecl(child);
                        child.parent = attribute;
                        attribute = child;
                        curr = child;
                    }
                    attribute.setAttributeName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDAttlistAttributeType: {
                    DTDAttlistDecl attribute = (DTDAttlistDecl)curr;
                    attribute.setAttributeType(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDAttlistAttributeValue: {
                    DTDAttlistDecl attribute = (DTDAttlistDecl)curr;
                    attribute.setAttributeValue(scanner.getTokenOffset(), scanner.getTokenEnd());
                    if (attribute.parent.isDTDAttListDecl()) {
                        curr = attribute.parent;
                        break;
                    }
                    isInitialDeclaration = false;
                    break;
                }
                case DTDStartEntity: {
                    while (!curr.isDoctype()) {
                        curr.end = scanner.getTokenOffset();
                        curr = curr.getParentNode();
                    }
                    DTDEntityDecl child = new DTDEntityDecl(scanner.getTokenOffset(), text.length());
                    curr.addChild(child);
                    curr = child;
                    break;
                }
                case DTDEntityPercent: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setPercent(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEntityName: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEntityValue: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setValue(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEntityKindPUBLIC: 
                case DTDEntityKindSYSTEM: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setKind(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEntityPublicId: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setPublicId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEntitySystemId: {
                    DTDEntityDecl entity = (DTDEntityDecl)curr;
                    entity.setSystemId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDStartNotation: {
                    while (!curr.isDoctype()) {
                        curr.end = scanner.getTokenOffset();
                        curr = curr.getParentNode();
                    }
                    DTDNotationDecl child = new DTDNotationDecl(scanner.getTokenOffset(), text.length());
                    curr.addChild(child);
                    curr = child;
                    isInitialDeclaration = true;
                    break;
                }
                case DTDNotationName: {
                    DTDNotationDecl notation = (DTDNotationDecl)curr;
                    notation.setName(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDNotationKindPUBLIC: {
                    DTDNotationDecl notation = (DTDNotationDecl)curr;
                    notation.setKind(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDNotationKindSYSTEM: {
                    DTDNotationDecl notation = (DTDNotationDecl)curr;
                    notation.setKind(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDNotationPublicId: {
                    DTDNotationDecl notation = (DTDNotationDecl)curr;
                    notation.setPublicId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDNotationSystemId: {
                    DTDNotationDecl notation = (DTDNotationDecl)curr;
                    notation.setSystemId(scanner.getTokenOffset(), scanner.getTokenEnd());
                    break;
                }
                case DTDEndTag: {
                    if (!curr.isDTDElementDecl() && !curr.isDTDAttListDecl() && !curr.isDTDEntityDecl() && !curr.isDTDNotationDecl()) break;
                    while (curr.parent != null && !curr.parent.isDoctype()) {
                        curr = curr.parent;
                    }
                    curr.end = scanner.getTokenEnd();
                    curr.closed = true;
                    curr = curr.parent;
                    break;
                }
                case DTDEndDoctypeTag: {
                    ((DOMDocumentType)curr).end = scanner.getTokenEnd();
                    curr.closed = true;
                    curr = curr.parent;
                    break;
                }
                case DTDUnrecognizedParameters: {
                    DTDDeclNode node = (DTDDeclNode)curr;
                    node.setUnrecognized(scanner.getTokenOffset(), ((XMLScanner)scanner).getLastNonWhitespaceOffset());
                    break;
                }
            }
            token = scanner.scan();
        }
        while (curr.parent != null) {
            curr.end = text.length();
            curr = curr.parent;
        }
        return xmlDocument;
    }

    private static boolean isEmptyElement(String tag) {
        return false;
    }
}

