/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.subscriptions.Subscription;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class MemorySubscriptionsRepository
implements ISubscriptionsRepository {
    private final Set<Subscription> subscriptions = new ConcurrentSkipListSet<Subscription>();

    @Override
    public Set<Subscription> listAllSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptions);
    }

    @Override
    public void addNewSubscription(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        this.subscriptions.stream().filter(s -> s.getTopicFilter().toString().equals(topic) && s.getClientId().equals(clientID)).findFirst().ifPresent(this.subscriptions::remove);
    }
}

