/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelListener;

public abstract class ResourceManager {
    protected static final ResourceSet set = new ResourceSetImpl();
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private boolean readOnly;

    public abstract long getModelTimeStamp();

    public abstract void saveModel();

    public void addListener(ModelListener list) {
        this.listeners.add(list);
    }

    public abstract Object getRootModel();

    public void removeListener(ModelListener list) {
        this.listeners.remove(list);
    }

    protected void fireEvent() {
        for (ModelListener list : this.listeners) {
            list.workspaceHasChanged();
        }
    }

    public static ResourceSet getResourceSet() {
        return set;
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static abstract class AbstractElementHandler
    implements IElementHandler {
        private final ResourceManager wsManager;
        private final Viewpoint viewpoint;

        protected AbstractElementHandler(Viewpoint viewpoint, ResourceManager wsManager) {
            this.viewpoint = viewpoint;
            this.wsManager = wsManager;
        }

        protected Viewpoint getViewpoint() {
            return this.viewpoint;
        }

        protected ResourceManager getResourceManager() {
            return this.wsManager;
        }

        protected void saveModel() {
            this.wsManager.saveModel();
        }

        protected String getIdentifier(ViewpointElement elt) {
            return elt.getId();
        }
    }
}

