/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.table;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.massactions.core.config.IMAConfiguration;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnfilter.IMAColumnFilter;
import org.polarsys.kitalpha.massactions.core.table.IMATable;
import org.polarsys.kitalpha.massactions.core.table.factory.IMAFactory;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.column.IMAColumnHeaderLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.corner.IMACornerLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.row.IMARowHeaderLayer;

public abstract class MATable
implements IMATable {
    private static final Log log = LogFactory.getLog(MATable.class);
    protected final Composite parentView;
    protected NatTable tableBase;
    protected boolean initialized;
    protected IMAGridLayer gridLayerStack;
    protected IMAConfiguration tableBaseConfig;
    protected IMAFactory factory;
    protected IMAColumnFilter currentFilter;

    public MATable(Composite parentView) {
        this.parentView = parentView;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.parentView.setLayout((Layout)gridLayout);
        this.initialized = false;
    }

    public abstract IMAFactory createMAFactory();

    protected void initialize(Collection<EObject> newData) {
        this.initialized = true;
        ConfigRegistry configRegistry = new ConfigRegistry();
        IMABodyLayer bodyLayerStack = this.getMAFactory().createBodyLayer(newData, this.getMAFactory());
        IMAColumnHeaderLayer columnHeaderLayerStack = this.getMAFactory().createColumnHeaderLayer(bodyLayerStack, (IConfigRegistry)configRegistry);
        IMARowHeaderLayer rowHeaderLayerStack = this.getMAFactory().createRowHeaderLayer(bodyLayerStack);
        IMACornerLayer cornerLayerStack = this.getMAFactory().createCornerLayer(columnHeaderLayerStack, rowHeaderLayerStack);
        this.gridLayerStack = this.getMAFactory().creatGridLayer(bodyLayerStack, columnHeaderLayerStack, rowHeaderLayerStack, cornerLayerStack);
        this.tableBase = new NatTable(this.parentView, (ILayer)this.gridLayerStack, false);
        this.tableBaseConfig = this.getMAFactory().createConfiguration(this.tableBase, (IConfigRegistry)configRegistry);
        this.tableBaseConfig.apply();
        this.currentFilter = this.getColumnFilterList().get(0);
        this.applyColumnFilter(this.currentFilter);
    }

    protected void update(Collection<EObject> newData) {
        this.gridLayerStack.dataChanged(newData);
        this.tableBaseConfig.dataChanged(newData);
    }

    @Override
    public void dataChanged(Collection<EObject> newData) {
        if (newData == null || newData.isEmpty()) {
            log.error((Object)"Invalid data list: Null or empty");
        } else if (!this.initialized) {
            this.initialize(newData);
        } else {
            this.update(newData);
        }
    }

    @Override
    public void saveState() {
        log.info((Object)"Saving state, does nothing for now");
    }

    @Override
    public boolean setFocus() {
        if (this.tableBase != null && !this.tableBase.isDisposed()) {
            return this.tableBase.setFocus();
        }
        return this.parentView.setFocus();
    }

    protected IMAFactory getMAFactory() {
        if (this.factory == null) {
            this.factory = this.createMAFactory();
        }
        return this.factory;
    }

    @Override
    public IMAConfiguration getTableBaseConfig() {
        return this.tableBaseConfig;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void dispose() {
        if (this.tableBase != null) {
            this.saveState();
            this.initialized = false;
            this.tableBaseConfig.dispose();
            this.tableBase.dispose();
        }
    }

    @Override
    public IMAGridLayer getGridLayerStack() {
        return this.gridLayerStack;
    }

    @Override
    public boolean commitAndCloseActiveCellEditor() {
        return this.tableBase.commitAndCloseActiveCellEditor();
    }

    @Override
    public void clearSelection() {
        this.gridLayerStack.getBodyLayer().getSelectionLayer().clear();
    }

    @Override
    public void applyColumnFilter(IMAColumnFilter columnFilter) {
        this.gridLayerStack.getBodyLayer().applyColumnFilter(columnFilter);
        this.currentFilter = columnFilter;
    }

    @Override
    public List<IMAColumnFilter> getColumnFilterList() {
        return this.gridLayerStack.getBodyLayer().getColumnFilterList();
    }

    @Override
    public NatTable getNatTable() {
        return this.tableBase;
    }
}

