/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.fix.RenameUnusedVariableFixCore;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class RenameUnusedVariableCleanUpCore
extends AbstractMultiFix {
    public RenameUnusedVariableCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public RenameUnusedVariableCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        return this.isEnabled("cleanup.remove_unused_local_variables");
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return RenameUnusedVariableFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.remove_unused_local_variables"));
    }

    @Override
    public ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return RenameUnusedVariableFixCore.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.remove_unused_local_variables"));
    }

    public Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLambdaParameter", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        buf.append("    public void bar() {\n");
        if (!this.isEnabled("cleanup.remove_unused_local_variables")) {
            String code = "record R(int i, long l) {}\n\nR r = new R(1, 1);\nswitch (r) {\n   \tcase R(_, long l) -> {}\n   \tcase R r2 -> {}\n}\n";
            buf.append(code);
        } else {
            String code = "record R(int i, long l) {}\n\nR r = new R(1, 1);\nswitch (r) {\n   \tcase R(_, _) -> {}\n   \tcase R _ -> {}\n}\n";
            buf.append(code);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (RenameUnusedVariableFixCore.isUnusedMember(problem) || RenameUnusedVariableFixCore.isUnusedLambdaParameter(problem)) {
            return this.isEnabled("cleanup.remove_unused_local_variables");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                int id = problem.getID();
                if (id == 536870973) {
                    ProblemLocation location = new ProblemLocation(problem);
                    SimpleName name = UnusedCodeFixCore.getUnusedName(compilationUnit, location);
                    if (RenameUnusedVariableFixCore.canRenameToUnnamedVariable(compilationUnit, name)) {
                        ++result;
                    }
                } else if (id == 536871193) {
                    ++result;
                }
                ++n2;
            }
        }
        return result;
    }
}

