/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;

public class CollectingSearchRequestor
extends SearchRequestor {
    private final ArrayList<SearchMatch> fFound = new ArrayList();
    private final ReferencesInBinaryContext fBinaryRefs;

    public CollectingSearchRequestor() {
        this(null);
    }

    public CollectingSearchRequestor(ReferencesInBinaryContext binaryRefs) {
        this.fBinaryRefs = binaryRefs;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (!this.filterMatch(match)) {
            this.collectMatch(match);
        }
    }

    public void collectMatch(SearchMatch match) {
        this.fFound.add(match);
    }

    public boolean filterMatch(SearchMatch match) throws CoreException {
        if (this.fBinaryRefs == null) {
            return false;
        }
        if (match.getAccuracy() == 0 && CollectingSearchRequestor.isBinaryElement(match.getElement())) {
            this.fBinaryRefs.add(match);
            return true;
        }
        return false;
    }

    private static boolean isBinaryElement(Object element) throws JavaModelException {
        if (element instanceof IMember) {
            return ((IMember)element).isBinary();
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        if (element instanceof IClassFile) {
            return false;
        }
        if (element instanceof IPackageFragment) {
            return CollectingSearchRequestor.isBinaryElement(((IPackageFragment)element).getParent());
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 2;
        }
        return false;
    }

    public List<SearchMatch> getResults() {
        return this.fFound;
    }
}

