/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.fix.UnimplementedCodeFixCore;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ModifierChangeCorrectionProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class ModifierCorrectionSubProcessorCore<T> {
    public static final String KEY_MODIFIER = "modifier";
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    public static final int ADD_MISSING_BODY = 256;
    public static final int CHANGE_TO_ABSTRACT = 257;
    public static final int CHANGE_MODIFIER = 258;
    public static final int ADD_METHOD_MODIFIER = 259;
    public static final int CHANGE_METHOD_VISIBILITY = 260;
    public static final int CHANGE_HIDDEN_METHOD_VISIBILITY = 261;
    public static final int MAKE_FINAL = 261;
    private static final int REMOVE_INVALID_MODIFIERS = 512;
    private static final int REMOVE_INVALID_FINAL_MODIFIER = 513;
    private static final int INVALID_STATIC_MODIFIER = 514;
    private static final int ADD_STATIC_TO_PARENT = 515;
    private static final int REMOVE_METHOD_BODY = 768;
    private static final int CHANGE_TO_STATIC = 769;
    private static final int CHANGE_TO_DEFAULT = 770;
    private static final int REMOVE_ABSTRACT = 771;
    private static final int REMOVE_NATIVE_MODIFIER = 1024;
    private static final int CHANGE_TO_SEALED = 1280;
    private static final int CHANGE_TO_NONSEALED = 1281;
    public static final int MAKE_DEPRECATED = 1536;

    public static void installLinkedVisibilityProposals(LinkedProposalModelCore linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface, String groupId) {
        Modifier modifier = ModifierCorrectionSubProcessorCore.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int[] nArray;
            int selected = modifier.getKeyword().toFlagValue();
            LinkedProposalPositionGroupCore positionGroup = linkedProposalModel.getPositionGroup(groupId, true);
            positionGroup.addPosition(rewrite.track((ASTNode)modifier), false);
            positionGroup.addProposal(new ModifierLinkedModeProposal(selected, 10));
            if (inInterface) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    positionGroup.addProposal(new ModifierLinkedModeProposal(flagValues[i], 9 - i));
                }
                ++i;
            }
        }
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModelCore linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface) {
        ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(linkedProposalModel, rewrite, modifiers, inInterface, KEY_MODIFIER);
    }

    private static Modifier findVisibilityModifier(List<IExtendedModifier> modifiers) {
        for (IExtendedModifier curr : modifiers) {
            Modifier modifier;
            Modifier.ModifierKeyword keyword;
            if (!(curr instanceof Modifier) || (keyword = (modifier = (Modifier)curr).getKeyword()) != Modifier.ModifierKeyword.PUBLIC_KEYWORD && keyword != Modifier.ModifierKeyword.PROTECTED_KEYWORD && keyword != Modifier.ModifierKeyword.PRIVATE_KEYWORD) continue;
            return modifier;
        }
        return null;
    }

    public void getMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        Expression expression;
        Type returnType;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ModifierCorrectionSubProcessorCore.removeModifier(decl, rewrite, 1024);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
        if (!decl.isConstructor() && (returnType = decl.getReturnType2()) != null && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType, decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_addmissingbody_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 9);
        proposals.add(this.astRewriteCorrectionProposalToT(proposal, 256));
        IMethodBinding binding = decl.resolveBinding();
        if (modifierNode == null && binding != null) {
            String label2 = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertoabstract_description, ModifierCorrectionSubProcessorCore.getMethodLabel(binding));
            int included = binding.getDeclaringClass().isInterface() ? 0 : 1024;
            int excluded = 65544;
            ModifierChangeCorrectionProposalCore proposal2 = new ModifierChangeCorrectionProposalCore(label2, cu, (IBinding)binding, (ASTNode)decl, included, excluded, 8);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal2, 257));
        }
    }

    public void getNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, int kind, int relevance) throws CoreException {
        String name;
        IMethodBinding bindingDecl;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 88: {
                binding = ((NameQualifiedType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        if (binding instanceof IVariableBinding && problem.getProblemId() == 0x1000003) {
            binding = ((IVariableBinding)binding).getType();
        }
        if (binding instanceof IMethodBinding && problem.getProblemId() == 0x1000003) {
            binding = ((IMethodBinding)binding).getReturnType();
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodDecl = (IMethodBinding)binding;
            if (methodDecl.isDefaultConstructor()) {
                this.collectConstructorProposals(context, problem, proposals);
                return;
            }
            bindingDecl = methodDecl.getMethodDeclaration();
            typeBinding = methodDecl.getDeclaringClass();
            name = BasicElementLabels.getJavaElementName(methodDecl.getName() + "()");
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding varDecl = (IVariableBinding)binding;
            typeBinding = varDecl.getDeclaringClass();
            name = BasicElementLabels.getJavaElementName(binding.getName());
            isLocalVar = !varDecl.isField();
            bindingDecl = varDecl.getVariableDeclaration();
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            bindingDecl = typeBinding.getTypeDeclaration();
            name = BasicElementLabels.getJavaElementName(binding.getName());
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessorCore.getNeededVisibility(selectedNode, typeBinding, binding);
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessorCore.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, name);
                    includedModifiers = 8;
                    if (bindingDecl.getKind() != 4) break;
                    excludedModifiers = 66560;
                    break;
                }
                case 4: {
                    if (typeBinding != null && typeBinding.isInterface()) {
                        return;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononstatic_description, name);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    int visibility;
                    if (typeBinding != null && cu.getParent().getElementName().equals(typeBinding.getPackage().getName())) {
                        visibility = 0;
                        excludedModifiers = 2;
                    } else {
                        visibility = 1;
                        includedModifiers = 1;
                        excludedModifiers = 7;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessorCore.getVisibilityString(visibility)});
                    break;
                }
                case 5: {
                    if (typeBinding != null && typeBinding.isInterface()) {
                        return;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = typeBinding == null || isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding.getTypeDeclaration());
            if (targetCU != null) {
                ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, targetCU, (IBinding)bindingDecl, selectedNode, includedModifiers, excludedModifiers, relevance);
                proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 258));
            }
        }
        if (kind == 2 && bindingDecl.getKind() == 3) {
            this.getVariableProposals(context, problem, (IVariableBinding)bindingDecl, proposals);
        } else if (kind == 1 && bindingDecl.getKind() == 3 && problem.getProblemId() == 0x8000087 && selectedNode.getNodeType() == 42 && selectedNode.getLocationInParent() == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            this.getVariableProposals(context, problem, (IVariableBinding)bindingDecl, proposals);
        }
    }

    public void getOverridingDeprecatedMethodProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        AST ast = methodDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MarkerAnnotation annot = ast.newMarkerAnnotation();
        annot.setTypeName(ast.newName("Deprecated"));
        rewrite.getListRewrite((ASTNode)methodDecl, methodDecl.getModifiersProperty()).insertFirst((ASTNode)annot, null);
        Javadoc javadoc = methodDecl.getJavadoc();
        if (javadoc != null) {
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@deprecated");
            JavadocTagsSubProcessorCore.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_overrides_deprecated_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 15);
        proposals.add(this.astRewriteCorrectionProposalToT(proposal, 1536));
    }

    public void getAddMethodModifierProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, int modifier, String label) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding binding = ((MethodDeclaration)selectedNode).resolveBinding();
        if (binding != null) {
            binding = binding.getMethodDeclaration();
            ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, cu, (IBinding)binding, selectedNode, modifier, 0, 5);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 259));
        }
    }

    public void getChangeOverriddenModifierProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, int kind) throws JavaModelException {
        List<IMethodBinding> methods;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        if (kind == 2 && problem.getProblemId() != 67109274 && !(methods = Bindings.findOverriddenMethods(method, false, false)).isEmpty()) {
            int includedModifiers = 0;
            for (IMethodBinding binding : methods) {
                int temp = JdtFlags.getVisibilityCode((IBinding)binding);
                includedModifiers = JdtFlags.getHigherVisibility(temp, includedModifiers);
            }
            int excludedModifiers = 7;
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodvisibility_description, new String[]{ModifierCorrectionSubProcessorCore.getVisibilityString(includedModifiers)});
            ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 261));
        }
        IMethodBinding overriddenInClass = null;
        ArrayList<ITypeBinding> motherClasses = new ArrayList<ITypeBinding>();
        while (overriddenInClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            motherClasses.add(curr);
            overriddenInClass = Bindings.findOverriddenMethodInType(curr, method);
        }
        if (overriddenInClass == null) {
            motherClasses.add(0, method.getDeclaringClass());
            HashSet<IMethodBinding> methodBindings = new HashSet<IMethodBinding>();
            for (ITypeBinding motherClass : motherClasses) {
                ModifierCorrectionSubProcessorCore.findOverriddenMethodInType(motherClass, method, methodBindings);
            }
            if (!methodBindings.isEmpty()) {
                overriddenInClass = (IMethodBinding)methodBindings.iterator().next();
                for (IMethodBinding methodBinding : methodBindings) {
                    if (Bindings.equalDeclarations((IBinding)overriddenInClass, (IBinding)methodBinding)) continue;
                    overriddenInClass = null;
                    break;
                }
            }
        }
        if (overriddenInClass != null) {
            IMethodBinding overriddenDecl = overriddenInClass.getMethodDeclaration();
            ICompilationUnit overriddenMethodCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), overriddenDecl.getDeclaringClass());
            if (overriddenMethodCU != null) {
                String label;
                int includedModifiers;
                int excludedModifiers;
                IMethodBinding targetMethod = overriddenDecl;
                ICompilationUnit targetCU = overriddenMethodCU;
                switch (kind) {
                    case 2: {
                        if (JdtFlags.isPrivate((IBinding)method)) {
                            targetMethod = method;
                            targetCU = cu;
                            excludedModifiers = 7;
                            includedModifiers = JdtFlags.getVisibilityCode((IBinding)overriddenDecl);
                        } else if (JdtFlags.isPackageVisible((IBinding)method) && !overriddenDecl.getDeclaringClass().getPackage().isEqualTo((IBinding)method.getDeclaringClass().getPackage())) {
                            excludedModifiers = 2;
                            includedModifiers = 4;
                            if (JdtFlags.isProtected((IBinding)overriddenDecl)) {
                                return;
                            }
                        } else {
                            excludedModifiers = 7;
                            includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                            if (JdtFlags.getVisibilityCode((IBinding)overriddenDecl) == JdtFlags.getVisibilityCode((IBinding)method)) {
                                return;
                            }
                        }
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changeoverriddenvisibility_description, new String[]{ModifierCorrectionSubProcessorCore.getMethodLabel(targetMethod), ModifierCorrectionSubProcessorCore.getVisibilityString(includedModifiers)});
                        break;
                    }
                    case 5: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononfinal_description, ModifierCorrectionSubProcessorCore.getMethodLabel(targetMethod));
                        excludedModifiers = 16;
                        includedModifiers = 0;
                        break;
                    }
                    case 4: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, ModifierCorrectionSubProcessorCore.getMethodLabel(targetMethod));
                        excludedModifiers = 8;
                        includedModifiers = 0;
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)"not supported");
                        return;
                    }
                }
                ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, targetCU, (IBinding)targetMethod, selectedNode, includedModifiers, excludedModifiers, 7);
                proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 260));
            }
        }
    }

    public void getNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, BasicElementLabels.getJavaElementName(binding.getName()));
            ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, cu, binding, selectedNode, 16, 0, 5);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 261));
        }
    }

    public void getRemoveInvalidModifiersProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            selectedNode = ((MethodDeclaration)selectedNode).getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            ASTNode parentType;
            ITypeBinding declClass;
            String methodName = BasicElementLabels.getJavaElementName(binding.getName());
            String label = null;
            int problemId = problem.getProblemId();
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problemId) {
                case 67109225: 
                case 67109271: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                    break;
                }
                case 33554778: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changefieldmodifiertononstatic_description, methodName);
                    break;
                }
                case 33554777: {
                    excludedModifiers = 64;
                    label = CorrectionMessages.ModifierCorrectionSubProcessor_removevolatile_description;
                    break;
                }
                case 67109914: {
                    excludedModifiers = -68618;
                    if (!Modifier.isAbstract((int)binding.getModifiers())) break;
                    excludedModifiers |= 0x800;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -26;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: 
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3392;
                    break;
                }
                case 67109233: {
                    excludedModifiers = -8;
                    break;
                }
                case 16777966: {
                    excludedModifiers = -2050;
                    break;
                }
                case 33555183: {
                    excludedModifiers = -1;
                    break;
                }
                case 67109624: {
                    excludedModifiers = -3;
                    break;
                }
                case 16777969: {
                    excludedModifiers = -2064;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            if (label == null) {
                label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_removeinvalidmodifiers_description, methodName);
            }
            ModifierChangeCorrectionProposalCore proposal1 = new ModifierChangeCorrectionProposalCore(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal1, 512));
            ModifierChangeCorrectionProposalCore proposal2 = new ModifierChangeCorrectionProposalCore(CorrectionMessages.ModifierCorrectionSubProcessor_removefinal_description, cu, binding, selectedNode, 0, 16, relevance + 1);
            if (problemId == 33554777) {
                proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal2, 513));
            }
            if (problemId == 33554778 && binding instanceof IVariableBinding && (declClass = ((IVariableBinding)binding).getDeclaringClass()).isMember()) {
                ASTNode parentType2;
                int modifiers = binding.getModifiers();
                if (!Modifier.isStatic((int)modifiers)) {
                    ModifierChangeCorrectionProposalCore proposal3 = new ModifierChangeCorrectionProposalCore(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostaticfinal_description, cu, binding, selectedNode, 16, 64, relevance + 1);
                    proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal3, 514));
                }
                if ((parentType2 = context.getASTRoot().findDeclaringNode((IBinding)declClass)) != null) {
                    ModifierChangeCorrectionProposalCore proposal4 = new ModifierChangeCorrectionProposalCore(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType2, 8, 0, relevance - 1);
                    proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal4, 515));
                }
            }
            if (problemId == 67109225 && binding instanceof IMethodBinding && (declClass = ((IMethodBinding)binding).getDeclaringClass()).isMember() && (parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass)) != null) {
                ModifierChangeCorrectionProposalCore proposal5 = new ModifierChangeCorrectionProposalCore(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1);
                proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal5, 515));
            }
        }
    }

    public void getAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTRewrite rewrite;
        AST ast;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        boolean parentIsInterface = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
            parentIsInterface = parentTypeDecl.isInterface();
        }
        boolean hasNoBody = decl.getBody() == null;
        int id = problem.getProblemId();
        if (id == 67109227 || id == 67109622 || id == 67109629 || parentIsAbstractClass) {
            ast = astRoot.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            ModifierCorrectionSubProcessorCore.removeModifier(decl, rewrite, 1024);
            if (hasNoBody) {
                Expression expr;
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Type returnType = decl.getReturnType2();
                if (returnType != null && (expr = ASTNodeFactory.newDefaultExpression(ast, returnType, decl.getExtraDimensions())) != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 6);
            proposals.add(this.astRewriteCorrectionProposalToT(proposal, 771));
        }
        if (!hasNoBody && id == 603979889) {
            ast = decl.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            rewrite.remove((ASTNode)decl.getBody(), null);
            int excluded = parentIsInterface ? -1026 : -1030;
            ModifierRewrite.create(rewrite, (ASTNode)decl).setModifiers(0, excluded, null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 5);
            proposals.add(this.astRewriteCorrectionProposalToT(proposal, 768));
            if (parentIsInterface) {
                String label2 = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, decl.getName());
                int included = 8;
                int excluded2 = 66560;
                proposal = new ModifierChangeCorrectionProposalCore(label2, cu, (IBinding)decl.resolveBinding(), (ASTNode)decl, included, excluded2, 8);
                proposals.add(this.modifierChangeCorrectionProposalCoreToT((ModifierChangeCorrectionProposalCore)proposal, 769));
                label2 = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertodefault_description, decl.getName());
                included = 65536;
                excluded2 = 1032;
                proposal = new ModifierChangeCorrectionProposalCore(label2, cu, (IBinding)decl.resolveBinding(), (ASTNode)decl, included, excluded2, 8);
                proposals.add(this.modifierChangeCorrectionProposalCoreToT((ModifierChangeCorrectionProposalCore)proposal, 770));
            }
        }
        if (id == 67109227 && parentTypeDecl != null) {
            this.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals);
        }
    }

    public void getAbstractTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        TypeDeclaration parentTypeDecl = null;
        if (selectedNode instanceof SimpleName) {
            ASTNode parent = selectedNode.getParent();
            if (parent != null) {
                parentTypeDecl = (TypeDeclaration)parent;
            }
        } else if (selectedNode instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)selectedNode;
        }
        if (parentTypeDecl == null) {
            return;
        }
        this.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals);
    }

    public void getNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        Expression expr;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ModifierCorrectionSubProcessorCore.removeModifier(decl, rewrite, 256);
        Block newBody = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
        Type returnType = decl.getReturnType2();
        if (returnType != null && (expr = ASTNodeFactory.newDefaultExpression(ast, returnType, decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_removenative_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, cu, rewrite, 6);
        proposals.add(this.astRewriteCorrectionProposalToT(proposal, 1024));
        if (decl.getBody() != null) {
            ASTRewrite rewrite2 = ASTRewrite.create((AST)decl.getAST());
            rewrite2.remove((ASTNode)decl.getBody(), null);
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            ASTRewriteCorrectionProposalCore proposal2 = new ASTRewriteCorrectionProposalCore(label2, cu, rewrite2, 5);
            proposals.add(this.astRewriteCorrectionProposalToT(proposal2, 768));
        }
    }

    public void getNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, BasicElementLabels.getJavaElementName(binding.getName()));
            ModifierChangeCorrectionProposalCore proposal = new ModifierChangeCorrectionProposalCore(label, cu, binding, selectedNode, 16, 0, 5);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 261));
        }
    }

    void addMakeTypeAbstractProposal(IInvocationContext context, TypeDeclaration parentTypeDecl, Collection<T> proposals) {
        UnimplementedCodeFixCore.MakeTypeAbstractOperation operation = new UnimplementedCodeFixCore.MakeTypeAbstractOperation(parentTypeDecl);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, BasicElementLabels.getJavaElementName(parentTypeDecl.getName().getIdentifier()));
        UnimplementedCodeFixCore fix = new UnimplementedCodeFixCore(label, context.getASTRoot(), new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
        FixCorrectionProposalCore proposal = new FixCorrectionProposalCore(fix, null, 5, context);
        proposals.add(this.fixCorrectionProposalCoreToT(proposal, 257));
    }

    public void getSealedMissingModifierProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ModifierChangeCorrectionProposalCore proposal;
        String label;
        if (proposals == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        if (!(selectedNode.getParent() instanceof TypeDeclaration)) {
            return;
        }
        TypeDeclaration typeDecl = (TypeDeclaration)selectedNode.getParent();
        boolean isInterface = typeDecl.isInterface();
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding typeDeclBinding = typeDecl.resolveBinding();
        int relevance = 5;
        if (!isInterface) {
            label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_final_description, typeDecl.getName());
            proposal = new ModifierChangeCorrectionProposalCore(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 16, 0, relevance);
            proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 261));
        }
        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_sealed_description, typeDecl.getName());
        proposal = new ModifierChangeCorrectionProposalCore(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 512, 0, relevance);
        proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal, 1280));
        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_nonsealed_description, typeDecl.getName());
        ModifierChangeCorrectionProposalCore proposal2 = new ModifierChangeCorrectionProposalCore(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 4096, 0, relevance);
        proposals.add(this.modifierChangeCorrectionProposalCoreToT(proposal2, 1281));
    }

    static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType, IBinding binding) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            if (binding != null && (JdtFlags.isProtected(binding) || binding.getKind() == 2)) {
                return 1;
            }
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.ModifierCorrectionSubProcessor_default;
    }

    private static void findOverriddenMethodInType(ITypeBinding currentType, IMethodBinding method, Set<IMethodBinding> methodBindings) {
        ITypeBinding[] interfaces;
        ITypeBinding[] iTypeBindingArray = interfaces = currentType.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interface0 = iTypeBindingArray[n2];
            IMethodBinding overriddenInInterface = Bindings.findOverriddenMethodInType(interface0, method);
            if (overriddenInInterface != null) {
                methodBindings.add(overriddenInInterface);
            }
            ModifierCorrectionSubProcessorCore.findOverriddenMethodInType(interface0, method, methodBindings);
            ++n2;
        }
    }

    public static Modifier removeModifier(MethodDeclaration decl, ASTRewrite rewrite, int modifier) {
        Modifier modifierNode = ASTNodes.findModifierNode(modifier, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        return modifierNode;
    }

    public static String getMethodLabel(IMethodBinding targetMethod) {
        return BasicElementLabels.getJavaElementName(targetMethod.getDeclaringClass().getName() + "." + targetMethod.getName());
    }

    protected abstract T astRewriteCorrectionProposalToT(ASTRewriteCorrectionProposalCore var1, int var2);

    protected abstract T modifierChangeCorrectionProposalCoreToT(ModifierChangeCorrectionProposalCore var1, int var2);

    protected abstract T fixCorrectionProposalCoreToT(FixCorrectionProposalCore var1, int var2);

    protected abstract void collectConstructorProposals(IInvocationContext var1, IProblemLocation var2, Collection<T> var3);

    protected abstract void getVariableProposals(IInvocationContext var1, IProblemLocation var2, IVariableBinding var3, Collection<T> var4);

    private static class ModifierLinkedModeProposal
    extends LinkedProposalPositionGroupCore.ProposalCore {
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier, int relevance) {
            super(null, relevance);
            this.fModifier = modifier;
        }

        @Override
        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        @Override
        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        @Override
        public TextEdit computeEdits(int offset, LinkedPosition currentPosition, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                IDocument document = currentPosition.getDocument();
                MultiTextEdit edit = new MultiTextEdit();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && IndentManipulation.isIndentChar((char)document.getChar(k))) {
                        ++k;
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(end, k - end, ""));
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, ""));
                } else {
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString()));
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        edit.addChild((TextEdit)new ReplaceEdit(end, 0, String.valueOf(' ')));
                    }
                }
                return edit;
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", 4, e.getMessage(), (Throwable)e));
            }
        }
    }
}

