/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.client.compiler.repositoryconnection.CompilationJob;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.AbstractRepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;

public class CompilerRepositoryClient
extends AbstractRepositoryClient {
    private Repository repository;

    public CompilerRepositoryClient() {
        IntentLogger.getInstance().log(IIntentLogger.LogType.LIFECYCLE, "[Compiler] Ready");
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
        this.repository.register((RepositoryClient)this);
    }

    protected Job createNotificationJob(RepositoryChangeNotification notification) {
        try {
            if (this.repositoryObjectHandler.getRepositoryAdapter().getContext() == null) {
                this.repositoryObjectHandler.getRepositoryAdapter().openSaveContext();
            }
        }
        catch (ReadOnlyException e) {
            IntentLogger.getInstance().logError((Throwable)e);
        }
        return new CompilationJob(this.repository, this.repositoryObjectHandler);
    }

    public void dispose() {
        this.repositoryObjectHandler.getRepositoryAdapter().closeContext();
        this.repository.unregister((RepositoryClient)this);
        super.dispose();
    }
}

