/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch.doc;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.etrice.generator.launch.GeneratorConfigTab;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class DocGeneratorConfigTab
extends GeneratorConfigTab {
    public static final String INCLUDE_IMAGES = "includeImages";
    private Button includeImages;

    protected void addFurtherControls(Composite mainComposite) {
        super.addFurtherControls(mainComposite);
        this.createSeparator(mainComposite, 2);
        this.includeImages = this.createCheckButton(mainComposite, "include image links in document");
        this.includeImages.setToolTipText("this option generates image links for behavior and structure diagrams and the instance tree diagram");
        this.includeImages.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.includeImages.addSelectionListener((SelectionListener)new GeneratorConfigTab.UpdateConfig((GeneratorConfigTab)this));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.includeImages.setSelection(configuration.getAttribute(INCLUDE_IMAGES, false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute(INCLUDE_IMAGES, this.includeImages.getSelection());
    }

    public String getName() {
        return "Doc Generator";
    }

    protected String getSrcgenDirPreferenceConstantName() {
        return "GeneratedDocuDirectory";
    }
}

